/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DataInputX  = require('./../io/data-inputx'),
    License     = require('./../conf/license'),
    Cypher      = require('./../util/cypher'),
    IPUtil      = require('./../util/iputil'),
    OidUtil     = require('./../util/oidutil'),
    ProcessSeq  = require('./../util/process-seq'),
    HashUtil    = require('./../util/hashutil');

var cluster = require('cluster');
const Configuration = require("../conf/configure");

var lastOid = 0;

var SecurityMaster = {
    ONAME: '',
    IP: 0,
    PCODE: 0,
    OKIND : 0,
    OKIND_NAME : null,
    ONODE : 0,
    ONODE_NAME : null,
    OID: 0 ,
    run : function(cb){
        var conf = require('./../conf/configure');
        if( this.resetLicense( conf.license )) {
            require('../logger').print('WHATAP-110', "[pcode=" + this.PCODE
                + ",SECURE_KEY=" + this.SECURE_KEY.toString('hex')
                + "]", false);
            this.getClusterId(cb);
        } else {
            if(cb) cb(new Error('Invalid license'));
        }
    },
    resetLicense: function(lic /* String */){
        try {
            var key = License.getKey(lic);
            if(key.pcode == null || key.security_key == null) {
                throw new Error('Invalid license');
            }
            this.PCODE = key.pcode;
            this.SECURE_KEY = key.security_key;
            this.cypher = new Cypher(this.SECURE_KEY, 0);
            return true;
        } catch(e) {
            require('../logger').printError('WHATAP-606', 'LicenseKey is invalid ' + lic, e, true);
        }
        return false;
    },
    updateLocalIp: function(myIp){
        process.env["whatap.ip"] = myIp;
        this.IP = 0;
    },
    decideAgentOnameOid: function(myIp) {
        var Configuration = require('./../conf/configure');
        Configuration.setProperty('whatap.ip', myIp);

        this.IP = IPUtil.stringToInt(myIp);
        var port = Configuration.getProperty("whatap.port");
        OidUtil.setIp(IPUtil.intToString(this.IP));
        OidUtil.setPort(port);
        OidUtil.setPid(process.pid);
        OidUtil.setHostName(require('os').hostname());
        //OidUtil.setType(Configuration.getProperty("whatap.type", "NODE"));
        OidUtil.setType(process.env.name || Configuration.getProperty("whatap.type", "NODE"));

        var name_pattern;
        if(Configuration.getProperty('whatap_micro_enabled', false) === true || process.env.WHATAP_MICRO_ENABLED === "true"){
            name_pattern = process.env.WHATAP_NAME || "{okind}-{ip2}-{ip3}";
        }else if(require('cluster').isMaster){
            name_pattern=process.env.WHATAP_NAME || "{type}-{ip2}-{ip3}";
        }else{
            name_pattern=process.env.WHATAP_NAME || "{type}{cluster}-{ip2}-{ip3}";
            var cid = Configuration.getProperty('node.clusterId');
            OidUtil.setCluster(cid);
        }

        var okindStr= process.env.WHATAP_OKIND ||  Configuration.getProperty('whatap.okind');
        if(okindStr && okindStr.length>0){
            this.OKIND = HashUtil.hashFromString(okindStr);
            this.OKIND_NAME=okindStr;
            OidUtil.setOkind(okindStr);
        }else{
            this.OKIND = 0;
            this.OKIND_NAME=null;
        }

        const whatapMicroEnabledConfig = Configuration.getProperty('whatap_micro_enabled', false);
        const whatapMicroEnabledEnv = process.env.WHATAP_MICRO_ENABLED;

        if (!whatapMicroEnabledConfig || whatapMicroEnabledEnv === undefined || whatapMicroEnabledEnv === "false") {
            var onodeStr= process.env.WHATAP_ONODE || process.env.NODE_NAME ||  Configuration.getProperty('whatap.onode', null);
            if(onodeStr && onodeStr.length>0){
                this.ONODE = HashUtil.hashFromString(onodeStr);
                this.ONODE_NAME=onodeStr;
            }else{
                this.ONODE = 0;
                this.ONODE_NAME=null;
            }
        }

        //OidUtil.setCmd(Configuration.getProperty("sun.java.command"));
        this.ONAME = OidUtil.mkOname(Configuration.getProperty("whatap.name", name_pattern), port);
        this.OID = OidUtil.mkOid(this.ONAME);

        if (lastOid != this.OID) {
            lastOid = this.OID;
            require('../logger').print('WHATAP-968', "OID: " + this.OID + " ONAME: " + this.ONAME + " IP: " + IPUtil.intToString(this.IP), false);
        }
    },
    setAgentOnameOid :function (oname, myIp) {
        var Configuration = require('./../conf/configure');
        Configuration.setProperty('whatap.ip', myIp);

        this.IP = IPUtil.stringToInt(myIp);//DataInputX.toInt(IPUtil.toBytes(myIp), 0);
        var port = Configuration.getProperty("whatap.port");
        OidUtil.setIp(IPUtil.intToString(this.IP));
        OidUtil.setPort(port);
        OidUtil.setPid(process.pid);
        OidUtil.setHostName(require('os').hostname());
        if(require('cluster').isMaster){
            OidUtil.setType(Configuration.getProperty("whatap.type", "NODE"));
        }else{
            OidUtil.setType(Configuration.getProperty("whatap.type", "NODE"+ Configuration.getProperty('node.clusterId') ) );
        }

        OidUtil.setCmd(Configuration.getProperty("sun.java.command"));
        this.ONAME = oname;
        this.OID = OidUtil.mkOid(this.ONAME);

        var okindStr= process.env.WHATAP_OKIND ||  Configuration.getProperty('whatap.okind');
        if(okindStr && okindStr.length>0){
            this.OKIND = HashUtil.hashFromString(okindStr);
            this.OKIND_NAME=okindStr;
        }else{
            this.OKIND = 0;
            this.OKIND_NAME=null;
        }

        const whatapMicroEnabledConfig = Configuration.getProperty('whatap_micro_enabled', false);
        const whatapMicroEnabledEnv = process.env.WHATAP_MICRO_ENABLED;

        if (!whatapMicroEnabledConfig || whatapMicroEnabledEnv === undefined || whatapMicroEnabledEnv === "false") {
            var onodeStr= process.env.WHATAP_ONODE || process.env.NODE_NAME ||  Configuration.getProperty('whatap.onode', null);
            if(onodeStr && onodeStr.length>0){
                this.ONODE = HashUtil.hashFromString(onodeStr);
                this.ONODE_NAME=onodeStr;
            }else{
                this.ONODE = 0;
                this.ONODE_NAME=null;
            }
        }

        if (lastOid != this.OID) {
            lastOid = this.OID;
            require('../logger').print('WHATAP-168', "OID: " + this.OID + " ONAME: " + this.ONAME + " IP: " + IPUtil.intToString(this.IP), false);
        }
    },
    getClusterId: function(cb){
        var conf = require('./../conf/configure');
        if(cluster.isMaster){
            //console.log('현재 프로젝트는 MASTER 입니다!!!!');
            conf.setProperty('node.clusterId', '');
            if(cb) cb();
        }else{
            conf.setProperty('node.clusterId', cluster.worker.id);
            if(cb) cb();
            //console.log('현재 프로젝트는 ' + cluster.worker.id + ' 입니다!!!!');
            /*
            ProcessSeq('whatap').accessAuth(function(pseq){
                if(!pseq){
                    return;
                }
                var conf = require('./../conf/configure');
                conf.setProperty('node.clusterId', pseq);
                if(cb) cb();
            });
            */
        }

    }
};

module.exports = SecurityMaster;