/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


const conf = require('../conf/configure');
var NetFlag         = require('./netflag').NetFlag,
    ControlHandler  = require('./../control/control-handler'),
    DateUtil        = require('./../util/dateutil'),
    DataInputX      = require('../io/data-inputx'),
    Logger          = require('../logger');

function Receiver(){};

Receiver.prototype.read = function(out /*TcpReturn*/){
    try {
        if(conf.network_debug_enabled){
            Logger.print("[Receiver] input Data " ,out.code + " // " + out.transfer_key , false);
        }
        if(out.code === NetFlag.TIME_SYNC) {
            var din = new DataInputX(out.data);
            var prevAgentTime = din.readLong().toNumber();
            var serverTime = din.readLong().toNumber();
            var now = Date.now();
            var turnaroundTime = (now - prevAgentTime);

            if(turnaroundTime < 500) {
                DateUtil.setServerTime(serverTime, 1);
            }
            return;
        }

        if(conf.cypher_level > 0) {
            if(out.transfer_key != conf.TRANSFER_KEY) { return; }
            
            switch (NetFlag.getSecureMask(out.code)) {
                case NetFlag.SECURE_HIDE:
                    if(conf.cypher != null) {
                        out.data = conf.cypher.hide(out.data);
                    } else {
                        return;
                    }
                    break;
                case NetFlag.SECURE_CYPHER:
                    if(conf.cypher != null) {
                        out.data = conf.cypher.decrypt(out.data);
                    } else {
                        return;
                    }
                    break;
                default:
                    out.data = null;
            }
        }

        if(out.data != null && out.data.length > 0) {
            ControlHandler.add(new DataInputX(out.data).readPack());
        }
    } catch (e) {
        Logger.printError('WHATAP-195', 'Receiver error', e);
    }
};

module.exports = Receiver;