/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var NetFlag = function(flag){
    this.flag = flag;
}

NetFlag.SECURE_HIDE = 0x0001;
NetFlag.SECURE_CYPHER = 0x0002;
NetFlag.RESERVED1 = 0x0004;
NetFlag.RESERVED2 = 0x0008;
NetFlag.RESERVED3 = 0x0010;
NetFlag.RESERVED4 = 0x0020;
NetFlag.RESERVED5 = 0x0040;
NetFlag.RESERVED6 = 0x0080;
NetFlag.TIME_SYNC = 0xfe;
NetFlag.KEY_RESET = 0xff;
NetFlag.PREPARE_AGENT = 0xfc;

NetFlag.getSecureMask = function(code){
    if(code === NetFlag.KEY_RESET) return 0;
    return (code & NetFlag.SECURE_HIDE ) | ( code & NetFlag.SECURE_CYPHER);
};

NetFlag.isSecure = function(code) {
    if(code === NetFlag.KEY_RESET) return false;
    return (code & NetFlag.SECURE_HIDE) | (code & NetFlag.SECURE_CYPHER);
};

NetFlag.prototype.set = function(mask){
    this.flag = (this.flag | mask);
    return this;
};

NetFlag.prototype.isA = function(m){
    return (this.falg & m) != 0;
};

NetFlag.prototype.getFlag = function() {
    return this.flag;
};

module.exports.NetFlag = NetFlag;

var NetSrc = {
    AGENT_JAVA_EMBED    : 1,
    AGENT_JAVA_WATCHER  : 2,
    SERVER_YARD         : 3,
    SERVER_PROXY        : 4
};

module.exports.NetSrc = NetSrc;