var conf = require('../conf/configure');
var SecurityMaster      = require('../net/security-master');
var LogSinkPack = require('../pack/log-sink-pack');
var DataPackSender = require('../data/datapack-sender');
var DateUtil = require('../util/dateutil')
var ZipSend = require('./zip/zip-send');
var PiiMask = require('../pii/pii-mask')

function SenderUtil() {
    this.conf = conf;
    this.secu = SecurityMaster;
}

SenderUtil.prototype.send = function (log) {
    const p = new LogSinkPack();
    p.time = log.time;
    if (!p.time) {
        p.time = DateUtil.currentTime();
    }
    p.category = log.category;

    if (this.secu.ONAME) {
        p.tags.putString('oname', this.secu.ONAME);
    }
    if (this.conf.OKIND) {
        p.tags.putString('okindName', this.conf.OKIND_NAME);
    }
    if (this.conf.ONODE) {
        p.tags.putString('onodeName', this.conf.ONODE_NAME);
    }

    if (log.tags != null) {
        p.tags.putAllMapValue(log.tags);
    }
    if (log.fields != null) {
        if (p.fields == null) {
            p.fields = log.fields;
        } else {
            p.fields.putAllMapValue(log.fields);
        }
    }

    p.content = log.content;

    if(conf.getProperty("pii_mask_logsink_enabled", false)){
        // PiiMask.parseLogSink(p)
    }

    if(conf.getProperty('logsink_zip_enabled', false)){
        ZipSend.getInstance().add(p);
    }else{
        DataPackSender.sendLogSinkPack(p)
    }
};

module.exports = SenderUtil;