var conf = require('../conf/configure');
var LineLog = require('./line-log');
var LineLogUtil = require('./line-log-util');
var LogSender = require('./log-sender');
var TraceContextManager = require('../trace/trace-context-manager');

var LogTracer = function () {
    this.logSender = LogSender.getInstance();
}

LogTracer.prototype.addStdWrite = function (content, category) {
    var lineLog = new LineLog();
    lineLog.category = category

    var lineLogUtil = LineLogUtil.getInstance();
    lineLogUtil.checkLogContent(lineLog, content);

    if(lineLog.content){
        this.addTxTag(lineLog);
        this.logSender.add(lineLog)
    }
}

LogTracer.prototype.addTxTag = function (lineLog) {
    if(!lineLog){
        return;
    }

    var ctx = TraceContextManager.getCurrentContext();
    if(ctx){
        if(conf.getProperty('logsink_trace_txid_enabled', true) && !ctx.txid.isZero()){
            lineLog.fields.putLong('@txid', ctx.txid);
        }
        if(conf.getProperty('logsink_trace_mtid_enabled', true) && !ctx.mtid.isZero()){
            lineLog.fields.putLong('@mtid', ctx.mtid);
        }
    }
}

module.exports = LogTracer;