var Configure = require('../conf/configure');
var RequestQueue = require('../util/request-queue');
var Logger = require('../logger');
var SenderUtil = require('./sender-util');
var conf = require("../conf/configure");

var logsink_enabled = Configure.getProperty('logsink_enabled', false);
var logsink_queue_size = Configure.getProperty('logsink_queue_size', 1000);
conf.on('logsink_enabled', function(newProperty) {
    logsink_enabled = newProperty;
    if (logsink_enabled) {
        LogSender.getInstance().startProcessQueue();
    } else {
        LogSender.getInstance().stopProcessQueue();
        LogSender.resetInstance();
    }
});

class LogSender {
    constructor() {
        if (LogSender.instance) {
            return LogSender.instance;
        }
        this.queue = new RequestQueue(logsink_queue_size);
        this.isProcessing = false;
        LogSender.instance = this;

        if (logsink_enabled) {
            this.startProcessQueue();
        }
    }

    static getInstance() {
        if (!LogSender.instance) {
            LogSender.instance = new LogSender();
        }
        return LogSender.instance;
    }

    static resetInstance() {
        if(LogSender.instance){
            LogSender.instance = null;
        }
    }

    add(log) {
        this.queue.put(log);
    }

    async processQueue() {
        this.isProcessing = true;

        while (this.isProcessing) {
            var log = await this.queue.get();
            if(log){
                try {
                    var sendUtil = new SenderUtil();
                    sendUtil.send(log);
                } catch (error) {
                    Logger.printError('WHATAP-702', 'Error occurred during send LogSinkPack.' + error, false);
                }
            }
            await new Promise(resolve => setTimeout(resolve, 100));
        }
    }

    startProcessQueue() {
        if (!this.isProcessing) {
            this.processQueue();
        }
    }

    stopProcessQueue() {
        this.isProcessing = false;
    }
}

module.exports = LogSender;