var net             = require('net'),
    conf            = require('../conf/configure'),
    MapValue        = require('../value/map-value'),
    KubeUtil        = require('../util/kube-util'),
    StopWatch       = require('../util/stop-watch'),
    DataOutputX     = require('../io/data-outputx'),
    DataInputX      = require('../io/data-inputx'),
    IPUtil          = require('../util/iputil'),
    TcpRequestClientProxy = require('./../net/tcpreq-client-proxy'),
    Logger          = require('../logger'),
    SecurityMaster  = require('./../net/security-master');
    
const SLEEP_TIME = 15000;

var KubeClient = {
    intervalId: undefined,
    run: function(){
        var self = this;
        if(this.intervalId){
            clearInterval(this.intervalId); this.intervalId = undefined;
        }
        this.intervalId = setInterval(function(){
            self.process(conf.pod_name);
        },SLEEP_TIME);
    },

    process: function(podName){
        var self = this;
        var p = new MapValue();

        var localAddr = (IPUtil.getIp());

        SecurityMaster.IP = IPUtil.stringToInt(localAddr);

		p.putString("cmd", "regist");
		p.putLong("pcode", SecurityMaster.PCODE);
		p.putLong("oid", SecurityMaster.OID);
        p.putString("oname", SecurityMaster.ONAME);
        
		p.putString("ip", IPUtil.intToString(SecurityMaster.IP));
		p.putString("hostname", require('os').hostname());
        p.putBoolean("kube.micro", true);

        if (podName != null) {
			p.putString("pod_name", podName);
		}
		if (conf.OKIND != 0) {
			p.putLong("okind", conf.OKIND);
			p.putString("okind_name", conf.OKIND_NAME);
		}
		if (conf.ONODE != 0) {
			p.putLong("onode", conf.ONODE);
			p.putString("onode_name", conf.ONODE_NAME);
		}
		if (KubeUtil.container_id != null) {
			p.putString("container_id", KubeUtil.container_id);
        }
    
        this.sendToMaster(p, function(){
            self.sendToNode(p);
        });
    },

    sendToNode: function(p){
        var self = this;

        try{
            var client = new TcpRequestClientProxy("Node " + self.node_agent_ip+ ":"+self.node_agent_port);
            client.open( self.node_agent_ip , self.node_agent_port, function(err, data){
                client.send(new DataOutputX().writeValue(p));
            }, function(err, data){
                if(err || !data){
                    return console.log("#### errordata" , err, data);
                }
                var m = new DataInputX(data).readValue();

                self.cpu = m.getFloat("cpu");
                self.cpu_sys = m.getFloat("cpu_sys");
                self.cpu_user = m.getFloat("cpu_user");
                self.throttled_periods = m.getFloat("throttled_periods");
                self.throttled_time = m.getFloat("throttled_time");

                self.memory = m.getLong("memory");
                self.failcnt = m.getLong("failcnt");
                self.limit = m.getLong("limit");
                self.maxUsage = m.getLong("maxUsage");

                self.node_recv_time = Date.now();
                self.metering = m.getFloat("metering");
            });
        }catch(e){
            return Logger.printError("WHATAP-128", 'Failed to connect to kubernetes Node!')
        }
    },

    sendToMaster: function(p, cb){
        var self = this;
        if (conf.master_agent_host == null) {
            return Logger.printError("WHATAP-129", 'master_agent_host=null', e)
		}

        var connectOptions = {
            host: 
            conf.master_agent_host
            // 'localhost'
            , port: conf.master_agent_port, agent: false
        };

        try{
            self.auto_oname_reset = conf.auto_oname_reset;

            var client = new TcpRequestClientProxy("Master " + connectOptions.host+ ":"+connectOptions.port);
            client.open( connectOptions.host , connectOptions.port, function(err, data){
                client.send(new DataOutputX().writeValue(p));
            }, function(err, data){
                if(data === undefined){
                    return Logger.printError('WHATAP-802', 'Are You Sure Kubernetes Container ??? (current whatap_micro_enabled=true)', new Error('No Master Whatap'), true);
                }
                
                var m = new DataInputX(data).readValue();
                self.node_agent_ip = m.getText("node.agent.ip");
                self.node_agent_port = m.getInt("node.agent.port");
                if(cb) cb();
            } );
        }catch(e){
            return Logger.printError("WHATAP-128", 'Failed to connect to kubernetes Master!', e)
        }
    },

    recvNodeAddr: function(m){
        var host = m['node.agent.ip'];
        var port = m['node.agent.port'];

        if(!host){
            this.node_agent_host = host;
        }

        if(!port && port !== 0){
            this.node_agent_port = port;
        }
    }
}

module.exports = KubeClient;