/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var conf            = require('../conf/configure'),
    secuMaster      = require('../net/security-master'),
    TcpRequestMgr   = require('../net/tcprequest-mgr'),
    NetFlag         = require('../net/netflag').NetFlag,
    ParamDef        = require('../net/paramdef'),
    DateUtil        = require('./../util/dateutil'),
    Long            = require('long');

var sendPack = function(p){
    if (p == null)
        return;

    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;
    
    switch (conf.encrypt_level || 2) {
        case 1:
            TcpRequestMgr.add(0, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendCounterPack = function(p){
    return sendPack(p);
};

var sendTagCounterPack = function(p){
    if (p == null) return;

    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    switch (conf.encrypt_level || 2) {
        case 1:
            TcpRequestMgr.add(0, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendHitMapPack1 = function(p){
    return sendPack(p);
};

var sendActiveStackPack = function(p){
    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    var enc_level = conf.encrypt_level || 2;
    switch (enc_level) {
        case 1:
            TcpRequestMgr.addProfile(0, p);
            break;
        case 2:
            TcpRequestMgr.addProfile(NetFlag.SECURE_HIDE, p);
            break;
        case 3:
        default:
            TcpRequestMgr.addProfile(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendTextPack = function(p){
    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    p.time = Long.fromNumber(DateUtil.currentTime());

    var enc_level = conf.encrypt_level || 2;

    switch (enc_level) {
        case 1:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendErrorSnapPack = function(p){
    return sendPack(p);
};

var sendProfilePack = function(p){

    p.pcode = secuMaster.PCODE ;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    var enc_level = conf.encrypt_level || 2;
    switch(enc_level) {
        case 1:
            break;
        case 2:
            TcpRequestMgr.addProfile(NetFlag.SECURE_CYPHER, p);
            break;
        case 3:
        default:
            TcpRequestMgr.addProfile(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendStatServicePack = function (p) {
    return sendPack(p);
};

var sendStatSqlPack = function(p){
    return sendPack(p);
};

var sendStatHttpcPack = function(p){
    return sendPack(p);
};

var sendStatErrorPack = function(p){
    return sendPack(p);
};

var sendRealtimeUserPack = function(p){
    return sendPack(p);
};

var sendStatRemoteIpPack = function(p){
    return sendPack(p);
};

var sendStatRemoteIpUrlPack = function(p){
    return sendPack(p);
};

var sendStatUserAgentPack = function(p){
    return sendPack(p);
};

var sendLogSinkPack = function(p){
    if (p == null)
        return;

    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    if (conf.getProperty('logsink_high_secure_enabled', false)) {
        TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
    }else{
        TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
    }
};

var sendEventPack = function(p){
    return sendPack(p);
};

var sendBoot = function(p){
    p.id = ParamDef.AGENT_BOOT_ENV;
    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;
    p.time = Long.fromNumber(DateUtil.currentTime());

    var enc_level = conf.encrypt_level || 2;
    switch (enc_level) {
        case 1:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendResponse = function(p){
    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    switch (conf.encrypt_level) {
        case 1:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var sendResponseHide = function(p){
    p.pcode = secuMaster.PCODE;
    p.oid = secuMaster.OID;
    p.okind=secuMaster.OKIND;
    p.onode=secuMaster.ONODE;

    switch (conf.encrypt_level) {
        case 1:
            TcpRequestMgr.add(NetFlag.SECURE_HIDE, p);
            break;
        case 2:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
        case 3:
        default:
            TcpRequestMgr.add(NetFlag.SECURE_CYPHER, p);
            break;
    }
};

var DataPackSender = {
    sendPack                : sendPack,
    sendCounterPack         : sendCounterPack,
    sendHitMapPack1         : sendHitMapPack1,
    sendActiveStackPack     : sendActiveStackPack,
    sendTextPack            : sendTextPack,
    sendErrorSnapPack       : sendErrorSnapPack,
    sendProfilePack         : sendProfilePack,
    sendTagCounterPack      : sendTagCounterPack,

    sendStatServicePack     : sendStatServicePack,
    sendStatSqlPack         : sendStatSqlPack,
    sendStatHttpcPack       : sendStatHttpcPack,
    sendStatErrorPack       : sendStatErrorPack,
    sendStatRemoteIpPack    : sendStatRemoteIpPack,
    sendStatRemoteIpUrlPack : sendStatRemoteIpUrlPack,
    sendStatUserAgentPack   : sendStatUserAgentPack,
    sendLogSinkPack         : sendLogSinkPack,

    sendRealtimeUserPack    : sendRealtimeUserPack,
    sendEventPack           : sendEventPack,
    sendBoot                : sendBoot,
    sendResponse            : sendResponse,
    sendResponseHide        : sendResponseHide
}

module.exports = DataPackSender;