/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    ResourceProfile = require('./../../util/resourceprofile'),
    KubeUtil            = require('./../../util/kube-util'),
    SecurityMaster  = require('../../net/security-master');

function SystemPerf(){
    CounterTask.call(this);
}

SystemPerf.prototype = new CounterTask();
SystemPerf.prototype.constructor = SystemPerf;
SystemPerf.prototype.process = function(p) {
    var cpu = ResourceProfile.getCPU();
    if (cpu == null) return;

    p.cpu = cpu.usage;
    p.cpu_sys = cpu.sys;
    p.cpu_usr = cpu.user;
    p.cpu_irq = cpu.irq;
    p.cpu_proc = cpu.proc;

    p.disk = ResourceProfile.getDisk().usage;

    if(p.version <= 1) p.mem = ResourceProfile.getMemory().usage;
    else p.mem = ResourceProfile.getMemoryV2().usage;

    p.cpu_cores = cpu.core;
    p.host_ip = SecurityMaster.IP;
    p.pid=process.pid;
    
    if (KubeUtil.container_id != null) {
        p.mem = 0;
        p.cpu = 0;
    }
};

module.exports = SystemPerf;