/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('./counter-task'),
    MeterSql    = require('../meter/meter-sql'),
    MeterActiveX = require('../meter/meter-activex'),
    IntKeyLinkedMap    = require('../../util/intkey-linkedmap'),
    conf        = require('../../conf/configure'),
    IntIntMap   = require('../../util/intint-map');

function Sql() {
    CounterTask.call(this);
}

Sql.prototype = new CounterTask();
Sql.prototype.constructor = CounterTask;
Sql.prototype.process = function (p) {
    var sql = MeterSql.getBucketReset();

    p.sql_time = sql.time;
    p.sql_count = sql.count;
    p.sql_error = sql.error;

    p.sql_fetch_count = sql.fetch_count;
    p.sql_fetch_time = sql.fetch_time;

    if(sql.db_conn_active.size() > 0 || sql.db_conn_idle.size() > 0) {
        if(p.db_num_active == null) {
            p.db_num_active = new IntIntMap(7, 1);
            p.db_num_idle = new IntIntMap(7, 1);
        }

        var enumer_acvive = sql.db_conn_active.entries();
        while(enumer_acvive.hasMoreElements()) {
            var entry = enumer_acvive.nextElement();
            p.db_num_active.add(entry.key, entry.value);
        }

        var enumer_idle = sql.db_conn_idle.entries();
        while(enumer_idle.hasMoreElements()) {
            var entry = enumer_idle.nextElement();
            p.db_num_idle.add(entry.key, entry.value);
        }

    }
    if (conf.sql_dbc_meter_enabled) {
        sql_meter(p);
    }   
    if (conf.actx_meter_enabled) {
        sql_actx_meter(p);
    }       
};

function sql_meter(p){
    if (MeterSql.stat.size() > 0) {
        p.sql_meter = new IntKeyLinkedMap();
        var en = MeterSql.stat.keys();
        for (var i = 0; i < 100 && en.hasMoreElements(); i++) {
            var key = en.nextElement();
            var b = MeterSql.stat.get(key);
            if(b != null) {
                p.sql_meter.put(key, {
                    time: b.time,
                    count: b.count,
                    error: b.error,
                    actx : 0,
                    fetch_count: b.fetch_count,
                    fetch_time: b.fetch_time
                });
            }
        }
        MeterSql.resetStat();
    }
}
function sql_actx_meter(p) {
    var meter = MeterActiveX;
    if (meter.stat_sql.size() > 0) {
        if (p.sql_meter == null) {
            p.sql_meter = new IntKeyLinkedMap();
        }
        var en = meter.stat_sql.keys();
        for (var i = 0; i < 100 && en.hasMoreElements(); i++) {
            var key = en.nextElement();
            var b = meter.stat_sql.get(key);
            var org = p.sql_meter.get(key);
            if (org) {
                org.actx = b;
            } else {
                p.sql_meter.put(key, {
                    time: 0,
                    count: 0,
                    error: 0,
                    actx: b,
                    fetch_count: 0,
                    fetch_time: 0
                });
            }
        }
    }
}

module.exports = Sql;