/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    MeterSocketio   = require('../meter/meter-socket.io'),
    WEBSOCKET       = require('../../pack/websocket'),
    Long            = require('long');

function Socketio() {
    CounterTask.call(this);
}

Socketio.prototype = new CounterTask();
Socketio.prototype.constructor = Socketio;
Socketio.prototype.process = function (p) {
    if(MeterSocketio.connected_count > 0) {
        if(p.websocket == null) {
            p.websocket = new WEBSOCKET();
        }
        p.websocket.count = MeterSocketio.connected_count;
        p.websocket.in = MeterSocketio.received_data;
        p.websocket.out = MeterSocketio.sent_data;
    }

};

module.exports = Socketio;