/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('../counter-task'),
    StatSql = require('../../../stat/stat-sql'),
    conf = require('../../../conf/configure'),
    ConfSysMon = require('../../../conf/conf-sys-mon'),
    SecurityMaster = require('../../../net/security-master'),
    TraceContextManager = require('../../../trace/trace-context-manager'),
    MeterActiveX = require('../../meter/meter-activex'),
    ActiveStackPack = require('../../../pack/activestack-pack'),
    ParamPack = require('../../../pack/param-pack'),
    EventPack = require('../../../pack/event-pack'),
    ActiveStackStep = require('../../../step/activestack-step'),
    DataPackSender = require('../../../data/datapack-sender'),
    DataTextAgent = require('../../../data/datatext-agent'),
    EventLevel  = require('../../../data/event-level'),
    MeterUsers = require('../../meter/meter-users'),
    KeyGen = require('../../../util/keygen'),
    TextTypes = require('../../../lang/text-types'),
    ResourceProfile = require('../../../util/resourceprofile'),
    Logger          = require('../../../logger'),
    HashUtil = require('../../../util/hashutil'),
    KubeUtil        = require('../../../util/kube-util'),
    KubeClient      = require('../../../kube/kube-client'),
    DateUtil        = require('../../../util/dateutil'),
    Long = require('long');

function SystemKubeTask() {
    CounterTask.call(this);

    this.last_metering = -1;
}

SystemKubeTask.prototype = new CounterTask();
SystemKubeTask.prototype.constructor = SystemKubeTask;
SystemKubeTask.prototype.process = function (p) {
    p.cpu_cores = 1;        // static one core in nodejs
    p.host_ip = SecurityMaster.IP;
    var now = Date.now();
    p.cpu = 0;
    p.mem = 0;
    if (p.metering != 0) {
        this.last_metering = p.metering;
    } else {
        p.metering = this.last_metering;
    }
};

module.exports = SystemKubeTask;