/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('../counter-task'),
    conf = require('../../../conf/configure'),
    SecurityMaster = require('../../../net/security-master'),
    AwsEcsClientThread = require('./util/awsEcsClientThread');

function SystemECSTask() {
    CounterTask.call(this);
}

SystemECSTask.prototype = new CounterTask();
SystemECSTask.prototype.constructor = SystemECSTask;
SystemECSTask.prototype.process = function (p) {
    p.host_ip = SecurityMaster.IP;

    var ecs = AwsEcsClientThread;

    setTimeout(() => {
        p.cpu = ecs.cpu * conf.correction_factor_cpu;
        p.cpu_sys = ecs.cpu_sys;
        p.cpu_usr = ecs.cpu_user;
        p.mem = ecs.mem_pct;

        if (ecs.millicore > 0) {
            p.metering = ecs.millicore / 1024;
            p.cpu_cores = Math.ceil(p.metering);
        } else {
            p.metering = p.cpu_cores;
        }
    }, 500);

};

module.exports = SystemECSTask;