/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    MeterUser       = require('../meter/meter-users'),
    // ResSysCpuPack= require('../../pack/ResSysCpu-pack'),
    SystemECSTask = require('./res/systemECSTask'),
    SystemKubeTask = require('./res/systemKubeTask'),
    ConfSysMon  = require('../../conf/conf-sys-mon'),
    DataPackSender  = require('../../data/datapack-sender'),
    Long            = require('long');

function ResSysCpu() {
    // this.systype = ConfSysMon.SysType.NONE;
    this.update();
}
ResSysCpu.prototype = new CounterTask();
ResSysCpu.prototype.constructor = ResSysCpu;
ResSysCpu.prototype.process = function (p) {

    this.init();

    if(this.sysmon) this.sysmon.process(p);
};

ResSysCpu.prototype.init = function () {
    // // WatchDog을 시작시킴
    // if (ConfWatchLog.watchlog_enabled) {
    //     WatchLogManager.getInstance();
    //     GcWatchManager.getInstance();
    // }
    // if (conf.WHATAP_MICRO_ENABLED) {
    //     KubeClient.getInstance();
    // }
    // if (ConfSysMon.aws_ecs_enabled) {
    //     AwsEcsClientThread.getInstance();
    // }
}

ResSysCpu.prototype.update = function () {
    var thisType = ConfSysMon.findType();

    if (this.systype == thisType)
        return;
    this.systype = thisType;

    switch (thisType) {
		case ConfSysMon.SysType.ECS:
            this.sysmon = new SystemECSTask();
            Logger.print('WHATAP SysCpu ' , "System CPU collected by 'ECS' task", undefined , true);
			break;
		case ConfSysMon.SysType.KUBE:
            this.sysmon = new SystemKubeTask();
            Logger.print('WHATAP SysCpu ' , "System CPU collected by 'KUBE", undefined , true);
			break;
    }
}

module.exports = ResSysCpu;