/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    MeterUser       = require('../meter/meter-users'),
    RealTimeUserPack= require('../../pack/realtimeuser-pack'),
    DataPackSender  = require('../../data/datapack-sender'),
    Long            = require('long');

function RealTimeUser() {

}
RealTimeUser.prototype = new CounterTask();
RealTimeUser.prototype.constructor = RealTimeUser;
RealTimeUser.prototype.process = function (p) {
    var hll = MeterUser.getRealtimeUsers();
    if(hll == null) {
        return;
    }

    var pk = new RealTimeUserPack();
    pk.time = p.time;
    pk.cadinality=hll.cardinality();
    pk.logbits = hll.getBytes();
    DataPackSender.sendRealtimeUserPack(pk);
};

module.exports = RealTimeUser;