/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    ResourceProfile = require('./../../util/resourceprofile'),
    Long            = require('long');

function ProcCpu() {
    CounterTask.call(this);
    this.oldCpu = 0;
}

ProcCpu.prototype = new CounterTask();
ProcCpu.prototype.constructor = ProcCpu;
ProcCpu.prototype.process = function (p) {
    var cpu = ResourceProfile.getCPU().times; /*long*/
    if(this.oldCpu<=0) {
        this.oldCpu = cpu;
        return;
    }
    var dTime = cpu - this.oldCpu;
    this.oldCpu = cpu;
    p.cputime = dTime;
};

module.exports = ProcCpu;