/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('./counter-task'),
    IntKeyLinkedMap = require('../../util/intkey-linkedmap'),
    MeterActiveX = require('../meter/meter-activex'),
    conf = require('../../conf/configure'),
    MeterHttpC = require('../meter/meter-httpc');

function HttpC() {
    CounterTask.call(this);
}

HttpC.prototype = new CounterTask();
HttpC.prototype.constructor = HttpC;
HttpC.prototype.process = function (p) {
    var httpc = MeterHttpC.getBucketReset();
    p.httpc_time = httpc.time;
    p.httpc_count = httpc.count;
    p.httpc_error = httpc.error;

    if (conf.httpc_host_meter_enabled) {
        httpc_host_meter(p);
    }
    if (conf.actx_meter_enabled) {
        httpc_actx_meter(p);
    }
};

function httpc_host_meter(p) {
    var meter = MeterHttpC;
    if (meter.stat.size() > 0) {
        p.httpc_meter = new IntKeyLinkedMap();
        var en = meter.stat.keys();
        for (var i = 0; i < 100 && en.hasMoreElements(); i++) {
            var key = en.nextElement();
            var b = meter.stat.get(key);
            p.httpc_meter.put(key, {
                time: b.time,
                count: b.count,
                error: b.error,
                actx : 0
            });
        }
        meter.resetStat();
    }
}

function httpc_actx_meter(p) {
    var meter = MeterActiveX;
    if (meter.stat_httpc.size() > 0) {
        if (p.httpc_meter == null) {
            p.httpc_meter = new IntKeyLinkedMap();
        }
        var en = meter.stat_httpc.keys();
        for (var i = 0; i < 100 && en.hasMoreElements(); i++) {
            var key = en.nextElement();
            var b = meter.stat_httpc.get(key);
            var org = p.httpc_meter.get(key);
            if (org) {
                org.actx = b;
            } else {
                p.httpc_meter.put(key, {
                    time: 0,
                    count: 0,
                    error: 0,
                    actx: b
                });
            }
        }
    }
}
module.exports = HttpC;