/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('./counter-task'),
    ResourceProfile = require('./../../util/resourceprofile');

function HeapMem() {
    CounterTask.call(this);
}

HeapMem.prototype = new CounterTask();
HeapMem.prototype.constructor = HeapMem;
HeapMem.prototype.process = function (p) {
    let m = undefined;
    if(p.version <= 1) m =ResourceProfile.getMemory();
    else m =ResourceProfile.getMemoryV2();

    p.heap_tot = m.heap_total;
    p.heap_use = m.heap_used;
};

module.exports = HeapMem;