/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask     = require('./counter-task'),
    ResourceProfile = require('../../util/resourceprofile');

function GcStat() {
    CounterTask.call(this);

    this.old = [];
}

GcStat.prototype = new CounterTask();
GcStat.prototype.constructor = GcStat;
GcStat.prototype.process = function (p) {
    var info = ResourceProfile.getCurrentProcGcInfo();
    if(this.old.length == 0) {
        p.gc_count = info[0];
        p.gc_time = info[1];
    } else {
        var tmp_count = info[0] - this.old[0];
        var tmp_time = info[1] - this.old[1];
        p.gc_count = tmp_count;
        p.gc_time = tmp_time;
        
    }
    this.old = info;
};

module.exports = GcStat;

