/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('./counter-task'),
    StatSql = require('../../stat/stat-sql'),
    conf = require('../../conf/configure'),
    SecurityMaster = require('../../net/security-master'),
    TraceContextManager = require('../../trace/trace-context-manager'),
    MeterActiveX = require('../meter/meter-activex'),
    ActiveStackPack = require('../../pack/activestack-pack'),
    ParamPack = require('../../pack/param-pack'),
    EventPack = require('../../pack/event-pack'),
    ActiveStackStep = require('../../step/activestack-step'),
    DataPackSender = require('../../data/datapack-sender'),
    DataTextAgent = require('../../data/datatext-agent').agent,
    EventLevel  = require('../../data/event-level'),
    MeterUsers = require('../meter/meter-users'),
    KeyGen = require('../../util/keygen'),
    TextTypes = require('../../lang/text-types'),
    ResourceProfile = require('../../util/resourceprofile'),
    Logger          = require('../../logger'),
    HashUtil = require('../../util/hashutil'),
    KubeUtil        = require('../../util/kube-util'),
    DateUtil        = require('../../util/dateutil'),
    fs = require('fs'),
    PiiMask = require('../../pii/pii-mask');

function AgentInfo() {
    CounterTask.call(this);

    this.startTime = Date.now();
    this.last_name_sent = 0;
}

AgentInfo.prototype = new CounterTask();
AgentInfo.prototype.constructor = AgentInfo;
AgentInfo.prototype.process = function (p) {
    // PiiMask.update();

    p.starttime = Date.now();
    /*
    if (p.starttime > this.startTime + DateUtil.MILLIS_PER_FIVE_MINUTE) {
        this.startTime = now + DateUtil.MILLIS_PER_HOUR * 12;

        DataPackSender.sendBoot(AgentInfo.info);
        // ComponentsVersions.send();
    }*/

    this.sendName(p.starttime);

    p.containerKey = KubeUtil.container_key;

    this.checkAutoScaleIn();
}

AgentInfo.prototype.sendName = function(now /* long */){
    if (now - this.last_name_sent < DateUtil.MILLIS_PER_FIVE_MINUTE) {
        return;
    }
    this.last_name_sent = now;
    
    var sm = SecurityMaster;
    if (sm.ONAME != null) {
        DataTextAgent.add(TextTypes.ONAME, sm.OID, sm.ONAME);
    }
    
    if (sm.OKIND != 0) {
        DataTextAgent.add(TextTypes.OKIND_NAME, sm.OKIND, sm.OKIND_NAME);
    }
    
    if (sm.ONODE != 0) {
        DataTextAgent.add(TextTypes.ONODE_NAME, sm.ONODE, sm.ONODE_NAME);
    }
    if (KubeUtil.container_key != 0) {
        DataTextAgent.add(TextTypes.CONTAINER_ID, KubeUtil.container_key, KubeUtil.container_id);
    }

    if (conf.simula_agent_count > 0) {
        for (var i = 0; i < conf.simula_agent_count; i++) {
            var oname = sm.ONAME + "#" + i;
            var ohash = HashUtil.hashFromString(oname);
            DataTextAgent.add(TextTypes.ONAME, ohash, oname);
        }
    }

    if(conf.mtrace_spec != undefined && conf.mtrace_spec.length >0) {
        DataTextAgent.add(TextTypes.MTRACE_SPEC, conf.mtrace_spec_hash, conf.mtrace_spec);
    }
}

AgentInfo.prototype.checkAutoScaleIn = function() {
    var home = conf["whatap.home"];
    var file = fs.existsSync(home, process.pid + ".shutdown");
    if (file) {
        var e = new EventPack();
        e.title = "SILENT_SHUTDOWN";
        e.level = EventLevel.INFO;
        DataPackSender.sendPack(e);
    }
}

module.exports = AgentInfo;


