/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var CounterTask = require('./counter-task'),
    StatSql = require('../../stat/stat-sql'),
    conf = require('../../conf/configure'),
    TraceContextManager = require('../../trace/trace-context-manager'),
    MeterActiveX = require('../meter/meter-activex'),
    ActiveStackPack = require('../../pack/activestack-pack'),
    ActiveStackStep = require('../../step/activestack-step'),
    DataPackSender = require('../../data/datapack-sender'),
    DataTextAgent = require('../../data/datatext-agent'),
    MeterUsers = require('../meter/meter-users'),
    KeyGen = require('../../util/keygen'),
    HashUtil = require('../../util/hashutil'),
    ResourceProfile = require('../../util/resourceprofile'),
    Logger          = require('../../logger'),
    Long = require('long');

function ActiveTransaction() {
    CounterTask.call(this);
    this.last_stack_sec = 0;
}

ActiveTransaction.prototype = new CounterTask();
ActiveTransaction.prototype.constructor = ActiveTransaction;
ActiveTransaction.prototype.process = function (p) {

    p.active_tx_slice = [0, 0, 0];
    p.active_stat = new Array(5).fill(0);

    var activeX = null;
    if (conf.actx_meter_enabled) {
        activeX = MeterActiveX;
        activeX.reinit();
    }

    var en = TraceContextManager.getContextEnumeration();
    try {
        while (en.hasMoreElements()) {
            var ctx = en.nextElement();
            if (ctx == null) {
                return false;
            }
            var elapsed = ctx.getElapsedTime();
            if (elapsed < conf.trace_active_transaction_yellow_time) {
                p.active_tx_slice[0]++;
            } else if (elapsed < conf.trace_active_transaction_red_time) {
                p.active_tx_slice[1]++;
            } else {
                p.active_tx_slice[2]++;
                if (elapsed >= conf.trace_active_transaction_hang_time) {
                    p.act_svc_hang++;
                }
            }
            p.active_tx_count++;
            if (activeX) {
                activeX.addTx(ctx.mcaller_pcode, ctx.mcaller_okind, ctx.mcaller_oid);
                var httpc = ctx.active_httpc_hash;
                if (httpc != 0) {
                    activeX.addHttpc(httpc);
                } else {
                    var dbc = ctx.active_dbc;
                    if (dbc != 0) {
                        activeX.addSql(dbc);
                    }
                }
            }


            if (ctx.active_sqlhash != 0) {
                p.active_stat[1]++; // sql
            } else if (ctx.active_httpc_hash != 0) {
                p.active_stat[2]++; // httpc
            } else if (ctx.db_opening) {
                p.active_stat[3]++; // dbc
            } else if (ctx.socket_connecting) {
                p.active_stat[4]++; // socket
            } else {
                p.active_stat[0]++; // method
            }

            MeterUsers.addActive(ctx.userid);
        }
    } catch (e) {
        Logger.printError("WHATAP-071", 'Active Transaction(process)', e)
    }

};

module.exports = ActiveTransaction;