/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var conf                = require('../../conf/configure'),
    LongKeyLinkedMap   = require('../../util/longkey-linkedmap'),
    HyperLogLog         = require('../../util/cardinality/hyperloglog'),
    Long                = require('long');

var add = function (userid) {
    if(conf.trace_user_enabled == false) { return; }

    if(userid instanceof Long  &&  userid.isZero() == false) {
        meterUser.users.putLast(userid, Date.now());
    }
};

var addActive = function (userid) {
    if(conf.trace_user_enabled == false) { return; }

    if(userid instanceof Long  &&  userid.isZero() == false) {
        meterUser.users.put(userid, Date.now());
    }
};

var getRealtimeUsers = function () {
    var max_think_time = conf.realtime_user_thinktime_max;
    var now = Date.now();

    var loglog = new HyperLogLog();
    if(meterUser.users.size() == 0) {
        return loglog;
    }

    var en = meterUser.users.entries();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        if(now - e.getValue() > max_think_time) {
            meterUser.users.remove(e.getKey());
        } else {
            loglog.offer(e.getKey());
        }
    }

    return loglog;
};

var meterUser = {
    MAX_USERS : 70000,
    users : new LongKeyLinkedMap().setMax(70000),
    add : add,
    addActive : addActive,
    getRealtimeUsers : getRealtimeUsers
};

module.exports = meterUser;