/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var conf      = require('../../conf/configure'),
    IntIntMap = require('../../util/intint-map'),
    Long      = require('long');
var IntKeyLinkedMap = require('../../util/intkey-linkedmap');

function Bucket() {
    this.count = 0;
    this.time = 0;
    this.error = 0;

    this.fetch_count = 0;
    this.fetch_time = 0;

    
    this.db_conn_active = new IntIntMap(7, 1);
    this.db_conn_idle = new IntIntMap(7, 1);
}

function MeterSql() {
    this.bucket = new Bucket();
    this.stat = new IntKeyLinkedMap(500, 1).setMax(500);
    this.stat.create = function (key) {
			return new Bucket();
	};
}

MeterSql.prototype.add = function (dbc, elapsed, err) {
    
    var b = this.bucket;
    b.count++;
    b.time +=elapsed;
    if(err) {
        b.error++;
    }
    if(conf.sql_dbc_meter_enabled && dbc!=0) {
        b = this.stat.intern(dbc);
        b.count++;

        b.time += elapsed;
        if (err) {
            b.error++;
        }
    }
};
MeterSql.prototype.getBucketReset = function () {
    var b = this.bucket;
    this.bucket = new Bucket();
    return b;
};
MeterSql.prototype.resetStat = function () {
    if(this.stat.size() > 0){
        this.stat.clear();
    }
}
MeterSql.prototype.addFetch = function (dbc, count, time) {
    this.bucket.fetch_count += count;
    this.bucket.fetch_time += time;
};

MeterSql.prototype.setConnection = function (active, idle, hash) {
    this.bucket.db_conn_active.put(hash, active);
    this.bucket.db_conn_idle.put(hash, idle);
};

module.exports = new MeterSql();