/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long = require('long');

function MeterSocketio() {

    if(typeof MeterSocketio.instance === 'object') {
        return MeterSocketio.instance;
    }

    this.total_connected = 0;
    this.connected_count = 0;
    this.received_count =0;
    this.received_data =0;
    this.sent_count =0;
    this.sent_data =0;

    MeterSocketio.instance = this;
}

MeterSocketio.prototype.connected = function (count) {
    this.total_connected += count;
    this.connected_count += count;
};
MeterSocketio.prototype.disconnected = function () {
    this.connected_count--;
};
MeterSocketio.prototype.receive = function (connectid, data) {
    if(typeof data === 'string') {
        this.received_data += data.length;
        this.received_count ++;
    } else if(typeof data === 'object') {
        this.received_data += JSON.stringify(data).length;
        this.received_count ++;
    }
};
MeterSocketio.prototype.send = function (connectid, data) {
    if(typeof data === 'string') {
        this.sent_data += data.length;
        this.sent_count ++;
    } else if(typeof data === 'object') {
        this.sent_data += JSON.stringify(data).length;
        this.sent_count ++;
    }
};

module.exports = new MeterSocketio();