/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var HitMapPack1 = require('../../pack/hitmap-pack1'),
    IntKeyMap = require('../../util/intkey-map'),
    SecurityMaster   = require('../../net/security-master'),
    conf = require('../../conf/configure'),
    secu = require('../../net/security-master'),
    IntKeyLinkedMap    = require('../../util/intkey-linkedmap'),
    LinkedMap    = require('../../util/linkedmap'),
    Logger       = require('../../logger'),
    EventLevel  = require('../../data/event-level');
    Long = require('long');

function Bucket () {
    this.hitmap = new HitMapPack1();
    this.count = 0;
    this.timesum = 0;
    this.error = 0;
    this.count_satisfied = 0;
    this.count_tolerated = 0;

    this.reset = function () {
        this.count = 0;
        this.timesum = 0;
        this.error = 0;
        this.count_satisfied = 0;
        this.count_tolerated = 0;
        this.hitmap = new HitMapPack1();
    };
}
function BucketSimple () {
    this.count = 0;
    this.timesum = 0;
    this.error = 0;
    this.count_satisfied = 0;
    this.count_tolerated = 0;

    this.reset = function () {
        this.count = 0;
        this.timesum =0;
        this.error = 0;
        this.count_satisfied = 0;
        this.count_tolerated = 0;
    };
}

function MeterService() {
    if(typeof MeterService.instance === 'object') {
        return MeterService.instance;
    }
    this.bucket = new Bucket();
    this.unknown = new BucketSimple();
    this.stat = new IntKeyLinkedMap(309, 1).setMax(307);
    this.stat.create = function (key) {
        return new BucketSimple();
	};
	this.statByGroup = new LinkedMap(309, 1).setMax(307);
    this.statByGroup.create = function (key) {
        return new BucketSimple();
    };
    this.statByGroup.hash = function (k) {
        if(k._hash_){
            return k._hash_;
        }
        var result = 1;
        result = 31 * result + k.pcode;
        result = 31 * result + k.okind;
        
        k._hash_=result;
        return result;
    };
    this.statByGroup.equals = function (k1,k2) {
        return k1.pcode === k2.pcode && k1.okind === k2.okind;
    };

    MeterService.instance = this;
}

MeterService.prototype.add = function (serviceHash, elapsed, errorLevel, caller_pcode,  caller_okind,  caller_oid , apdex) {
    if(elapsed < 0) {
        elapsed = 0;
    }

    var b = this.bucket;
    b.count += 1;
    b.timesum +=elapsed;
    
    var err = errorLevel >= EventLevel.WARNING;
    if (err) {
        b.error += 1;
    } else {
        if (elapsed <= conf.apdex_time_t) {
            b.count_satisfied += 1;
            apdex=2;
        } else if (elapsed <= conf.apdex_time_4t) {
            b.count_tolerated += 1;
            apdex=1;
        }
    }
    b.hitmap.add(elapsed, err);
    
    if (conf.tx_caller_meter_enabled) {
        try{
            var b1 = null;
            if(  caller_oid) {
                if (caller_pcode == SecurityMaster.PCODE) {
                        b1 = this.stat.intern(caller_oid);
                        b1.count++;
                        b1.timesum += elapsed;
                        if (err) {
                            b1.error++;
                        }
                }
                
                b1 = this.statByGroup.intern({pcode:caller_pcode, okind:caller_okind});
                b1.count++;
                b1.timesum += elapsed;
                if (err) {
                    b1.error++;
                }
            }else {
                b1 = this.unknown;
                b1.count++;
                b1.timesum += elapsed;
                if (err) {
                    b1.error++;
                }
            }
        }catch(e){
            Logger.printError('WHATAP-080', 'Meter Service add ', e, true);
        }
    }
};
MeterService.prototype.getBucket = function () {
    return this.bucket;
};
MeterService.prototype.resetStat = function () {
    if(this.stat.size() > 0){
        this.stat.clear();
    }
    if(this.statByGroup.size() > 0){
        this.statByGroup.clear();
    }
    if (this.unknown.count > 0) {
        this.unknown = new Bucket();
    }
};

function TopService(hash) {
    this.hash = hash | 0;
    this.count = 0;
    this.error = 0;
    this.time = 0;

    this.clear = function () {
        this.count = 0;
        this.error = 0;
        this.time = 0;
    };
};

module.exports.MeterService = new MeterService();
module.exports.Bucket = Bucket;
module.exports.TopService = TopService;