/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var IntKeyLinkedMap = require('../../util/intkey-linkedmap');
var Long            = require('long');
var Logger      = require('../../logger');
var conf      = require('../../conf/configure');
    
function Bucket() {
    this.count = 0;
    this.time =0;
    this.error = 0;
}

function MeterHttpC() {
    this.bucket = new Bucket();
    this.stat = new IntKeyLinkedMap(309, 1).setMax(307);
    this.stat.create = function (key) {
			return new Bucket();
	};
}

MeterHttpC.prototype.add = function (host,elapsed, err) {
    try {
        var b = this.bucket;
        b.count++;
        b.time += elapsed;
        if(err) {
            b.error++;
        }

        if (conf.httpc_host_meter_enabled && host != 0) {
			b = this.stat.intern(host);
			b.count++;
			b.time += elapsed;
			if (err) {
				b.error++;
            }
		}
    } catch(e) {
        Logger.printError("WHATAP-608", "MeterHttpC Error", e);
    }
};
MeterHttpC.prototype.getBucketReset = function () {
    var b = this.bucket;
    this.bucket = new Bucket();
    return b;
};
MeterHttpC.prototype.resetStat = function () {
    if(this.stat.size() > 0){
        this.stat.clear();
    }
}
module.exports = new MeterHttpC();
