/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var conf = require('../../conf/configure'),
    IntIntMap = require('../../util/intint-map'),
    secuMaster = require('../../net/security-master'),
    LinkedMap = require('../../util/linkedmap');


function MeterActiveX() {
    this.statByOid = new IntIntMap().setMax(2001);
    this.statByGroup = createLinkedMap();
    this.stat_sql = new IntIntMap().setMax(301);
    this.stat_httpc = new IntIntMap().setMax(301);
    this.unknown = 0;
}

MeterActiveX.prototype.addTx = function (caller_pcode, caller_okind, caller_oid) {
    if (caller_oid) {
        this.statByGroup.add({pcode:caller_pcode, okind:caller_okind}, 1);
        if (caller_pcode == secuMaster.PCODE) {
            this.statByOid.add(caller_oid, 1);
        }
    } else {
        this.unknown++;
    }

};
MeterActiveX.prototype.addSql = function (dbc) {
    this.stat_sql.add(dbc, 1);
};

MeterActiveX.prototype.addHttpc = function (host) {
    this.stat_httpc.add(host, 1);
};

MeterActiveX.prototype.reinit = function () {
    this.statByOid = new IntIntMap().setMax(2001);
    this.statByGroup = createLinkedMap();
    this.stat_sql = new IntIntMap().setMax(301);
    this.stat_httpc = new IntIntMap().setMax(301);
    this.unknown = 0;
};


function createLinkedMap() {
    var m = new LinkedMap(1009, 1).setMax(307);
    m.hash = function (k) {
        if (k._hash_) {
            return k._hash_;
        }
        var result = 1;
        result = 31 * result + k.pcode;
        result = 31 * result + k.okind;

        k._hash_ = result;
        return result;
    };
    m.equals = function (k1, k2) {
        return k1.pcode === k2.pcode && k1.okind === k2.okind;
    };
    return m;
}
module.exports = new MeterActiveX();