/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DataOutPutX = require('./../io/data-outputx'),
    DataInputX 	= require('./../io/data-inputx'),
    Hexa32 		= require('./../util/hexa32'),
    HashUtil 	= require('./../util/hashutil'),
    Logger      = require('../logger');

var License = function() {
};
License.getKey = function(lic){
    try{
        var tokens = lic.split('-');
        var out = new DataOutPutX( tokens.length  * 8 );
        for(var i = 0 ; i < tokens.length ; i++){
            var t = tokens[i].trim();
            out.writeLong( Hexa32.toLong32(t) );
        }
        var key = new Key();
        var dInX = new DataInputX( out.toByteArray() );
        key.pcode = dInX.readDecNumber();
        key.security_key = dInX.readBlob();
        return key;
    } catch(e) {
        Logger.printError('WHATAP-190', 'License Error', e);
    }
    return null;
};

var Key = function(){
    this.pcode = undefined;
    this.security_key = undefined;
};
Key.prototype.toString = function(){
    return "pcode : "+ this.pcode + "  security_key :  "+ HashUtil.hash( this.security_key );
};

module.exports = License;