/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var WHATAP_CONF  = process.env.WHATAP_CONF || 'whatap';

var fs = require('fs'),
    path = require('path'),
    EventEmitter = require('events').EventEmitter;

var DataInputX = require('./../io/data-inputx'),
    secu = require('./../net/security-master'),
    NodeUtil = require('./../util/nodeutil'),
    HashUtil = require('./../util/hashutil'),
    StringUtil = require('./../util/string-util'),
    Cypher = require('./../util/cypher'),
    ConfigDefault = require("./config-default"),
    MapValue = require('./../value/map-value'),
    ConfigUtil = require('../util/config-util'),
    SystemUtil = require('../util/system-util'),
    LinuxProcStatUtil = require('./../counter/task/res/util/linuxProcStatUtil'),
    lastModifiedTime = 0;

var num = ConfigUtil.num;
var str = ConfigUtil.str;
var bool = ConfigUtil.bool;

var ConfSysMon = function() {
    var self = this;
    EventEmitter.call(this);

    this.aws_ecs_enabled = false;
    this.linux_proc_stat_enabled = false;
    this.shell_perf_enabled = false;

    this.correction_factor_cpu = 1;
    this.correction_factor_pcpu = 1;
};

ConfSysMon.prototype = new EventEmitter();
ConfSysMon.prototype.constructor = ConfSysMon;

ConfSysMon.prototype.apply = function(properties) {

    try {
        var meta_uri = process.env["ECS_CONTAINER_METADATA_URI"];
        this.aws_ecs_enabled = meta_uri != null;
        if (this.aws_ecs_enabled) {
            this.aws_ecs_enabled = bool(conf["whatap.ecs.enabled"], true);
        }
    } catch (e) {
    }

    this.linux_proc_stat_enabled = bool(conf["linux_proc_stat_enabled"], false);
    this.shell_perf_enabled = bool(conf["shell_perf_enabled"], false);

    this.correction_factor_cpu = num(conf["correction_factor_cpu"], 1);
    this.correction_factor_pcpu = num(conf["correction_factor_pcpu"], 1);
}

ConfSysMon.prototype.SysType = {
    NONE: 'NONE',
    ECS: 'ECS',
    KUBE: 'KUBE',
    LINUX: 'LINUX',
    JMX: 'JMX',
    SHELL: 'SHELL',
    SIGAR: 'SIGAR'
}

ConfSysMon.prototype.findType = function(){
    var t = this.SysType.NONE;

    // dynamic reload!!!
    var Configure = require('./configure');

    if (Configure.whatap_micro_enabled || process.env.WHATAP_MICRO_ENABLED === "true") {
        t = this.SysType.KUBE;
    } else if (this.aws_ecs_enabled) {
        t = this.SysType.ECS;
    } else if (this.linux_proc_stat_enabled) {
        if (SystemUtil.IS_LINUX && LinuxProcStatUtil.isLinux()) {
            t = this.SysType.LINUX;
        } else {
            t = this.SysType.JMX;
        }
    } else if (this.shell_perf_enabled) {
        t = this.SysType.SHELL;
    } /*else if (this.sigar_enabled) {
        t = this.SysType.SIGAR;
    } */else {
        t = this.SysType.JMX;
    }
    return t;
};

const conf = new ConfSysMon();

module.exports = conf;