
[![WhaTap Logo](https://login.whatap.io/static/whatap_logo.png)](http://www.whatap.io/)

# Whatap for Node.js

Whatap allows for application performance monitoring.

Works on Linux(32bit, 64bit), MacOSx(32bit, 64bit), Windows(32bit, 64bit).

*Node.js 지원 버젼: 16.4.0 이상

![step01](http://apm.whatap.io/images/icon_step01.png)

#### Npm install

npm 에서 다음과 같은 명령어를 통해 whatap을 설치 할 수 있습니다.

    $ npm install whatap



![step02](http://apm.whatap.io/images/icon_step02.png)

#### License Key

node\_modules/whatap에 있는 whatap.conf파일을 루트 디렉토리로 복사 후
라이센스 키를 발급받은 후 추가 해 주세요.

whatap.conf 파일은 다음과 같은 내용을 포함합니다.

    license=XXXXXXXXXXXXXX-XXXXXXXXXXXXXX-XXXXXXXXXXXXXX
    whatap.server.host=XXX.XXX.XXX.XXX



![step03](http://apm.whatap.io/images/icon_step03.png)

#### Usage

루트 디렉토리에 위치한 Node.js 애플리케이션에서 Whatap 모니터링 기능을 활성화하려면, 
애플리케이션의 진입점 파일에 Whatap 에이전트를 초기화하는 코드를 추가해야 합니다.

Node.js 애플리케이션에 Whatap 모니터링을 적용하는 방법은 모듈 시스템의 종류(CommonJS 또는 ECMAScript Modules, ESM)에 따라 약간 다릅니다. 아래에서는 두 가지 모듈 시스템에 대해 Whatap 에이전트를 초기화하고 사용하는 방법을 설명합니다.


#### CommonJS 모듈 시스템 사용 시
Whatap 에이전트를 CommonJS 방식으로 가져오고 초기화하려면, 다음 코드를 애플리케이션의 진입점 파일에 추가하세요:
    
    var WhatapAgent = require('whatap').NodeAgent;

#### ECMAScript 모듈(ESM) 시스템 사용 시
ESM 방식으로 Whatap 에이전트를 가져오고 사용하려면, 다음과 같이 코드를 작성하세요:

    import WhatapAgent from 'whatap';
    WhatapAgent.NodeAgent;

![step04](http://apm.whatap.io/images/icon_step04.png)

#### Restart

어플리케이션 서버가 실행되면 애플리케이션의 모니터링 정보를 수집하기
시작합니다.
