/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import java.util.List;
import java.util.Map;
import whatap.agent.conf.ConfLogSink;
import whatap.lang.value.MapValue;
import whatap.logsink.LineLog;
import whatap.logsink.fw.LogTracer;
import whatap.v1.LogBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSink {
    public static void trace(String category, String content) {
        LogSink.trace(category, null, content);
    }

    public static void trace(String category, List<String[]> tags, String content) {
        if (ConfLogSink.logsink_logapi_enabled) {
            LineLog line = new LineLog();
            LogSink.putAll(line.tags, tags);
            line.category = category;
            line.content = content;
            LogTracer.logdirect(line);
        }
    }

    public static void trace(String category, Map<String, String> tags, Map<String, String> fields, String content) {
        if (ConfLogSink.logsink_logapi_enabled) {
            LineLog line = new LineLog();
            LogSink.putAll(line.tags, tags);
            LogSink.putAll(line.fields, fields);
            line.category = category;
            line.content = content;
            LogTracer.logdirect(line);
        }
    }

    public static void trace(long time, String category, Map<String, String> tags, Map<String, String> fields, String content) {
        if (ConfLogSink.logsink_logapi_enabled) {
            LineLog line = new LineLog();
            line.time = time;
            LogSink.putAll(line.tags, tags);
            LogSink.putAll(line.fields, fields);
            line.category = category;
            line.content = content;
            LogTracer.logdirect(line);
        }
    }

    private static void putAll(MapValue target, List<String[]> tagKeyVal) {
        if (tagKeyVal != null) {
            for (String[] ent : tagKeyVal) {
                target.put(ent[0], ent[1]);
            }
        }
    }

    private static void putAll(MapValue target, Map<String, String> map) {
        if (map != null) {
            target.putStringMapAll(map);
        }
    }

    public static void trace(LogBox log) {
        if (ConfLogSink.logsink_logapi_enabled) {
            LineLog line = new LineLog();
            LogSink.putAll(line.tags, log.tags);
            LogSink.putAll(line.fields, log.fields);
            line.category = log.category;
            line.content = log.content;
            LogTracer.logdirect(line);
        }
    }
}

