/*
 * Decompiled with CFR 0.152.
 */
package whatap.util.expr.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import whatap.util.ArrayUtil;
import whatap.util.expr.Function;
import whatap.util.expr.function.ArrayParamUtil;

public class Lower
implements Function {
    public Object process(List param) throws RuntimeException {
        if (param == null || param.size() != 2) {
            throw new RuntimeException("formula function invalid param size ");
        }
        try {
            ArrayList<Double> out = new ArrayList<Double>();
            Object o = param.get(0);
            double base = ArrayParamUtil.getDouble(param.get(1));
            if (o instanceof List) {
                ArrayParamUtil.lower((List)o, base, out);
            } else if (o instanceof Map) {
                ArrayParamUtil.lower((Map)o, base, out);
            } else if (o.getClass().isArray()) {
                ArrayParamUtil.lowerArr(o, base, out);
            } else {
                double d = ArrayParamUtil.getDouble(o);
                if (base >= d) {
                    out.add(d);
                }
            }
            switch (out.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return out.get(0);
                }
            }
            double[] ov = new double[out.size()];
            for (int i = 0; i < ov.length; ++i) {
                ov[i] = (Double)out.get(i);
            }
            return ov;
        }
        catch (Exception e) {
            throw new RuntimeException("formula function : " + e);
        }
    }

    public static void main(String[] args) {
        float[] o = new float[]{0.0f, 0.0f};
        System.out.println(o.getClass().getName());
        System.out.println(ArrayUtil.len((Object)o));
    }
}

