/*
 * Decompiled with CFR 0.152.
 */
package whatap.util.cardinality;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.cardinality.MurmurHash;
import whatap.util.cardinality.RegisterSet;

public class HyperLogLog {
    public boolean dirty;
    private final RegisterSet registerSet;
    private final int log2m;
    private final double alphaMM;

    public HyperLogLog() {
        this(10);
    }

    public HyperLogLog(double rsd) {
        this(HyperLogLog.log2m(rsd));
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    private static double rsd(int log2m) {
        return 1.106 / Math.sqrt(Math.exp((double)log2m * Math.log(2.0)));
    }

    private static void validateLog2m(int log2m) {
        if (log2m < 0 || log2m > 30) {
            throw new IllegalArgumentException("log2m argument is " + log2m + " and is outpcodee the range [0, 30]");
        }
    }

    public HyperLogLog(int log2m) {
        this(log2m, new RegisterSet(1 << log2m));
    }

    @Deprecated
    public HyperLogLog(int log2m, RegisterSet registerSet) {
        HyperLogLog.validateLog2m(log2m);
        this.registerSet = registerSet;
        this.log2m = log2m;
        int m = 1 << this.log2m;
        this.alphaMM = HyperLogLog.getAlphaMM(log2m, m);
    }

    public boolean offerHashed(long hashedValue) {
        int j = (int)(hashedValue >>> 64 - this.log2m);
        int r = Long.numberOfLeadingZeros(hashedValue << this.log2m | (long)((1 << this.log2m - 1) + 1)) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    public boolean offerHashed(int hashedValue) {
        int j = hashedValue >>> 32 - this.log2m;
        int r = Integer.numberOfLeadingZeros(hashedValue << this.log2m | (1 << this.log2m - 1) + 1) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    public boolean offer(Object o) {
        int x = MurmurHash.hash(o);
        return this.offerHashed(x);
    }

    public boolean offer(long o) {
        int x = MurmurHash.hashLong(o);
        return this.offerHashed(x);
    }

    public long cardinality() {
        double registerSum = 0.0;
        int count = this.registerSet.count;
        double zeros = 0.0;
        for (int j = 0; j < this.registerSet.count; ++j) {
            int val = this.registerSet.get(j);
            registerSum += 1.0 / (double)(1 << val);
            if (val != 0) continue;
            zeros += 1.0;
        }
        double estimate = this.alphaMM * (1.0 / registerSum);
        if (estimate <= 2.5 * (double)count) {
            return Math.round(HyperLogLog.linearCounting(count, zeros));
        }
        return Math.round(estimate);
    }

    public int sizeof() {
        return this.registerSet.size * 4;
    }

    public byte[] getBytes() {
        DataOutputX out = new DataOutputX();
        out.writeInt(this.log2m);
        out.writeInt(this.registerSet.size);
        for (int x : this.registerSet.readOnlyBits()) {
            out.writeInt(x);
        }
        return out.toByteArray();
    }

    public void addAll(HyperLogLog other) {
        if (this.sizeof() != other.sizeof()) {
            throw new RuntimeException("Cannot merge estimators of different sizes");
        }
        this.registerSet.merge(other.registerSet);
    }

    public HyperLogLog merge(HyperLogLog ... estimators) {
        HyperLogLog merged = new HyperLogLog(this.log2m, new RegisterSet(this.registerSet.count));
        merged.addAll(this);
        if (estimators == null) {
            return merged;
        }
        HyperLogLog[] hyperLogLogArray = estimators;
        int n = hyperLogLogArray.length;
        for (int i = 0; i < n; ++i) {
            HyperLogLog estimator;
            HyperLogLog hll = estimator = hyperLogLogArray[i];
            merged.addAll(hll);
        }
        return merged;
    }

    public static HyperLogLog build(byte[] bytes) {
        DataInputX in = new DataInputX(bytes);
        int log2m = in.readInt();
        int n = in.readInt();
        int[] ints = new int[n];
        for (int i = 0; i < n; ++i) {
            ints[i] = in.readInt();
        }
        return new HyperLogLog(log2m, new RegisterSet(1 << log2m, ints));
    }

    protected static double getAlphaMM(int p, int m) {
        switch (p) {
            case 4: {
                return 0.673 * (double)m * (double)m;
            }
            case 5: {
                return 0.697 * (double)m * (double)m;
            }
            case 6: {
                return 0.709 * (double)m * (double)m;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m;
    }

    protected static double linearCounting(int m, double V) {
        return (double)m * Math.log((double)m / V);
    }
}

