/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import whatap.util.LongKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHashQueue<V> {
    private LongKeyLinkedMap<V> queue;
    private int capacity;

    public RequestHashQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LongKeyLinkedMap();
    }

    public synchronized V getByKey(long key) {
        V out = this.queue.remove(key);
        while (out == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            out = this.queue.remove(key);
        }
        return out;
    }

    public synchronized V getFirst() {
        while (this.queue.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.queue.removeFirst();
    }

    public synchronized V getFirst(long timeout) {
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        long timeto = System.currentTimeMillis() + timeout;
        long time = timeout;
        while (this.queue.isEmpty()) {
            try {
                if (time > 0L) {
                    this.wait(time);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((time = timeto - System.currentTimeMillis()) > 0L) continue;
        }
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        return null;
    }

    public synchronized V getByKey(long key, long timeout) {
        V out = this.queue.remove(key);
        if (out != null) {
            return out;
        }
        long timeto = System.currentTimeMillis() + timeout;
        long time = timeout;
        while (out == null) {
            try {
                if (time > 0L) {
                    this.wait(time);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            out = this.queue.remove(key);
            time = timeto - System.currentTimeMillis();
            if (time > 0L) continue;
            break;
        }
        return out;
    }

    public synchronized boolean put(long key, V o) {
        if (this.capacity <= 0 || this.queue.size() < this.capacity) {
            this.queue.put(key, o);
            this.notifyAll();
            return true;
        }
        this.failed(key, o);
        this.notify();
        return false;
    }

    public synchronized boolean putForce(long key, V value) {
        if (this.capacity <= 0 || this.queue.size() < this.capacity) {
            this.queue.put(key, value);
            this.notifyAll();
            return true;
        }
        while (this.queue.size() >= this.capacity) {
            V v = this.queue.removeFirst();
            this.overflowed(v);
        }
        this.queue.put(key, value);
        this.notifyAll();
        return true;
    }

    protected void failed(long key, V o) {
    }

    protected void overflowed(V o) {
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int size) {
        this.capacity = size;
    }
}

