/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import whatap.lang.ref.OBJECT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamText {
    private String startBrace;
    private String endBrace;
    private List<Object> tokenList = new ArrayList<Object>();
    private List<String> keyList = new ArrayList<String>();

    public ParamText(String plainText) {
        this(plainText, "${", "}");
    }

    public ParamText(String plainText, String startBrace, String endBrace) {
        this.startBrace = startBrace;
        this.endBrace = endBrace;
        while (plainText.length() > 0) {
            int pos = plainText.indexOf(startBrace);
            if (pos < 0) {
                this.tokenList.add(plainText);
                return;
            }
            if (pos > 0) {
                this.tokenList.add(plainText.substring(0, pos));
                plainText = plainText.substring(pos);
                continue;
            }
            int nextPos = plainText.indexOf(endBrace, pos += startBrace.length());
            if (nextPos < 0) break;
            String argName = plainText.substring(pos, nextPos).trim();
            this.keyList.add(argName);
            this.tokenList.add(new OBJECT<String>(argName));
            plainText = plainText.substring(nextPos + endBrace.length());
        }
    }

    public String getText(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        int idx = 0;
        for (int i = 0; i < this.tokenList.size(); ++i) {
            Object o = this.tokenList.get(i);
            if (o instanceof OBJECT) {
                if (idx < args.length) {
                    buffer.append(args[idx++]);
                    continue;
                }
                buffer.append(o);
                continue;
            }
            buffer.append(o);
        }
        return buffer.toString();
    }

    public String getText(Object arg) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.tokenList.size(); ++i) {
            Object o = this.tokenList.get(i);
            if (o instanceof OBJECT) {
                buffer.append(arg);
                continue;
            }
            buffer.append(o);
        }
        return buffer.toString();
    }

    public String getText(Map<String, ?> argm) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.tokenList.size(); ++i) {
            Object o = this.tokenList.get(i);
            if (o instanceof OBJECT) {
                OBJECT p = (OBJECT)o;
                if (argm.containsKey(p.value)) {
                    buffer.append(argm.get(p.value));
                    continue;
                }
                buffer.append(o);
                continue;
            }
            buffer.append(o);
        }
        return buffer.toString();
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.tokenList.size(); ++i) {
            Object o = this.tokenList.get(i);
            if (o instanceof OBJECT) {
                buffer.append(this.startBrace).append(o).append(this.endBrace);
                continue;
            }
            buffer.append(o);
        }
        return buffer.toString();
    }
}

