/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

public class MathUtil {
    public static double round(double v) {
        return (long)v;
    }

    public static double round(double value, int scale) {
        if (scale == 0) {
            return (long)value;
        }
        long r = MathUtil.scale(scale);
        long v = (long)(value * (double)r);
        return (double)v / (double)r;
    }

    public static long scale(int n) {
        long r = 0L;
        switch (n) {
            case 1: {
                r = 10L;
                break;
            }
            case 2: {
                r = 100L;
                break;
            }
            case 3: {
                r = 1000L;
                break;
            }
            default: {
                r = 10000L;
            }
        }
        return r;
    }

    public static String roundString(double value, int scale) {
        if (scale <= 0) {
            return Long.toString((long)value);
        }
        return Double.toString(MathUtil.round(value, scale));
    }

    public static double round2(double value) {
        return MathUtil.round(value, 2);
    }

    public static double round4(double value) {
        return MathUtil.round(value, 4);
    }

    public static double getStandardDeviation(int count, double timeSum, double timeSqrSum) {
        if (count == 0) {
            return 0.0;
        }
        if (timeSqrSum == 0.0) {
            return 0.0;
        }
        double avg = timeSum / (double)count;
        double variation = timeSqrSum / (double)count - avg * avg;
        double ret = Math.sqrt(Math.abs(variation));
        return ret == Double.NaN ? 0.0 : ret;
    }

    public static double getPct90(double avg, double stdDev) {
        return avg + stdDev * 1.282;
    }

    public static double getPct95(double avg, double stdDev) {
        return avg + stdDev * 1.645;
    }
}

