/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongIntLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongIntLinkedEntry[] table;
    private LongIntLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public LongIntLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public LongIntLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongIntLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new LongIntLinkedEntry(0L, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongIntLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(1);
    }

    public synchronized IntEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<LongIntLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        LongIntLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongIntLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        LongIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized int get(long key) {
        LongIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized long getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized long getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized int getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized int getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongIntLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongIntLinkedEntry[] newMap = new LongIntLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongIntLinkedEntry old = oldMap[i];
            while (old != null) {
                LongIntLinkedEntry e = old;
                old = old.hash_next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LongIntLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(long key, int value) {
        return this._put(key, value, 4);
    }

    public int putLast(long key, int value) {
        return this._put(key, value, 2);
    }

    public int putFirst(long key, int value) {
        return this._put(key, value, 1);
    }

    private synchronized int _put(long key, int value, int m) {
        LongIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        long k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        long k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(long key, int value) {
    }

    public int add(long key, int value) {
        return this._add(key, value, 4);
    }

    public int addLast(long key, int value) {
        return this._add(key, value, 2);
    }

    public int addFirst(long key, int value) {
        return this._add(key, value, 1);
    }

    private synchronized int _add(long key, int value, int m) {
        LongIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                return e.value;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public synchronized int remove(long key) {
        LongIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntLinkedEntry e = tab[index];
        LongIntLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.max > 0 && this.max <= this.count;
    }

    public synchronized void clear() {
        LongIntLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongIntLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongIntLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongIntLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongIntLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LongIntLinkedEntry link_prev, LongIntLinkedEntry link_next, LongIntLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LongIntLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<LongIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            LongIntLinkedEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeDecimal(e.getValue());
        }
    }

    public LongIntLinkedMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            long key = in.readDecimal();
            int value = (int)in.readDecimal();
            this.put(key, value);
        }
        return this;
    }

    public synchronized void sort(Comparator<LongIntLinkedEntry> c) {
        ArrayList<LongIntLinkedEntry> list = new ArrayList<LongIntLinkedEntry>(this.size());
        Enumeration<LongIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            LongIntLinkedEntry e = (LongIntLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        LongIntLinkedMap m = new LongIntLinkedMap().setMax(6);
        for (int i = 0; i < 10; ++i) {
            m.put(i, i);
            System.out.println(m);
        }
        System.out.println();
        System.out.println(m);
        System.out.println("==================================");
        LongEnumer en = m.keys();
        while (en.hasMoreElements()) {
            m.remove(5L);
            System.out.println(en.nextLong());
        }
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public static class LongIntLinkedEntry {
        long key;
        int value;
        LongIntLinkedEntry hash_next;
        LongIntLinkedEntry link_next;
        LongIntLinkedEntry link_prev;

        protected LongIntLinkedEntry(long key, int value, LongIntLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new LongIntLinkedEntry(this.key, this.value, this.hash_next == null ? null : (LongIntLinkedEntry)this.hash_next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongIntLinkedEntry)) {
                return false;
            }
            LongIntLinkedEntry e = (LongIntLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32) ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    IntEnumer,
    LongEnumer {
        byte type;
        LongIntLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((LongIntLinkedMap)LongIntLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && LongIntLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                LongIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                LongIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 2: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                LongIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

