/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import whatap.util.FileUtil;
import whatap.util.Pair;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarUtil {
    public static void print() throws IOException {
        InputStream manifestStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = new Manifest(manifestStream);
            Attributes attributes = manifest.getMainAttributes();
            String impVersion = attributes.getValue("Implementation-Version");
            System.out.println(attributes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static File getToolsFile() throws Exception {
        String java_home = System.getProperty("java.home");
        File tools = new File(java_home, "../lib/tools.jar");
        if (!tools.canRead()) {
            java_home = System.getenv("JAVA_HOME");
            if (java_home == null) {
                throw new Exception("The JAVA_HOME environment variable is not defined correctly");
            }
            tools = new File(java_home, "lib/tools.jar");
            if (!tools.canRead()) {
                throw new Exception("The JAVA_HOME environment variable is not defined correctly");
            }
        }
        return tools;
    }

    public static String getThisJarName(Class this0) {
        if (this0 == null) {
            this0 = JarUtil.class;
        }
        return JarUtil.getJarFileName(this0);
    }

    public static String getJarLocation(Class class1) {
        try {
            String path = JarUtil.getJarFileName(class1);
            path = System.getProperty("os.name").contains("Windows") ? path.substring(0, path.lastIndexOf(92)) : path.substring(0, path.lastIndexOf(47));
            return path;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getJarFileName(Class class1) {
        boolean isWindows = false;
        if (System.getProperty("os.name").contains("Windows")) {
            isWindows = true;
        }
        try {
            String path = "" + class1.getResource("/" + class1.getName().replace('.', '/') + ".class");
            if (path.indexOf("!") < 0) {
                return null;
            }
            path = path.substring(isWindows ? "jar:file:/".length() : "jar:file:".length(), path.indexOf("!"));
            path = URLDecoder.decode(path, "UTF-8");
            return isWindows ? path.replace('/', '\\') : path.replace('\\', '/');
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getSpringJarName(Class class1) {
        try {
            String path = "" + class1.getResource("/" + class1.getName().replace('.', '/') + ".class");
            int x = path.lastIndexOf("!");
            if (x < 0) {
                return null;
            }
            x = (path = path.substring("jar:file:".length(), x)).indexOf("!");
            if (x > 0) {
                path = path.substring(x + 1);
            }
            path = URLDecoder.decode(path, "UTF-8");
            return path.replace('\\', '/');
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarVersion(File file) {
        String fileName;
        Attributes attr = null;
        JarFile jarfile = null;
        try {
            jarfile = new JarFile(file);
            attr = jarfile.getManifest().getMainAttributes();
        }
        catch (Throwable throwable) {
            FileUtil.close(jarfile);
        }
        catch (Throwable throwable) {
            FileUtil.close(jarfile);
            throw throwable;
        }
        FileUtil.close(jarfile);
        if (attr != null) {
            String ver = attr.getValue("Implementation-Version");
            if (ver != null) {
                return ver;
            }
            ver = attr.getValue("Bundle-Version");
            if (ver != null) {
                return ver;
            }
        }
        if ((fileName = file.getName().substring(0, file.getName().lastIndexOf("."))).contains(".")) {
            String mjrVer = fileName.substring(0, fileName.indexOf("."));
            int delimiter = mjrVer.lastIndexOf("-");
            if (mjrVer.indexOf("_") > delimiter) {
                delimiter = mjrVer.indexOf("_");
            }
            mjrVer = mjrVer.substring(delimiter + 1, fileName.indexOf("."));
            String minorVersion = fileName.substring(fileName.indexOf("."));
            return mjrVer + minorVersion;
        }
        return null;
    }

    public static String getJarFileNameVersion(String fileName) {
        int snx;
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && (snx = fileName.lastIndexOf("-")) < lastDot && snx > 0) {
            return fileName.substring(snx + 1, lastDot);
        }
        return null;
    }

    public static byte[] makeJarFile(StringKeyLinkedMap<byte[]> classes) throws IOException {
        return JarUtil.makeJarFile(classes, null);
    }

    public static byte[] makeJarFile(StringKeyLinkedMap<byte[]> classes, Manifest manifest) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (manifest == null) {
            manifest = new Manifest();
        }
        JarOutputStream jarOut = new JarOutputStream((OutputStream)bout, manifest);
        JarUtil.writeJarStream(classes, jarOut);
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJarStream(StringKeyLinkedMap<byte[]> classes, JarOutputStream jarOut) throws IOException {
        StringKeyLinkedMap<byte[]> resources = new StringKeyLinkedMap<byte[]>();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<byte[]>> en = classes.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<byte[]> entry = en.nextElement();
            resources.put(entry.getKey().replace('.', '/') + ".class", entry.getValue());
        }
        try {
            JarUtil.addEntries(jarOut, resources);
        }
        finally {
            jarOut.close();
        }
    }

    public static void addEntries(JarOutputStream jarOut, StringKeyLinkedMap<byte[]> files) throws IOException {
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<byte[]>> en = files.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<byte[]> entry = en.nextElement();
            JarEntry jarEntry = new JarEntry(entry.getKey());
            jarOut.putNextEntry(jarEntry);
            jarOut.write(entry.getValue());
            jarOut.closeEntry();
        }
    }

    public static List<File> getLastJarFiles(String path, String prefix, String version, String ext) {
        StringKeyLinkedMap<Pair<String, File>> jarfiles = new StringKeyLinkedMap<Pair<String, File>>();
        File[] files = new File(path).listFiles();
        for (int i = 0; i < files.length; ++i) {
            String lowercaseFileName = files[i].getName().toLowerCase();
            if (StringUtil.isNotEmpty(prefix) && !lowercaseFileName.startsWith(prefix) || StringUtil.isNotEmpty(version) && lowercaseFileName.indexOf(version) < 0 || StringUtil.isNotEmpty(ext) && !lowercaseFileName.endsWith(ext)) continue;
            String name = files[i].getName();
            Pair<String, String> parsed = JarUtil.parse(name);
            Pair<String, File> vnf = (Pair<String, File>)jarfiles.get(parsed.getLeft());
            if (vnf == null) {
                vnf = new Pair<String, File>(parsed.getRight(), files[i]);
            } else if (((String)vnf.getLeft()).compareTo(parsed.getRight()) < 0) {
                vnf = new Pair<String, File>(parsed.getRight(), files[i]);
            }
            jarfiles.put(parsed.getLeft(), vnf);
        }
        ArrayList<File> out = new ArrayList<File>();
        Enumeration en = jarfiles.values();
        while (en.hasMoreElements()) {
            Pair p = (Pair)en.nextElement();
            out.add((File)p.getRight());
        }
        return out;
    }

    public static List<File> getAllFiles(String path, String prefix, StringSet extSet) {
        StringKeyLinkedMap jarfiles = new StringKeyLinkedMap();
        ArrayList<File> out = new ArrayList<File>();
        File[] files = new File(path).listFiles();
        if (files == null) {
            return out;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            String lowercaseFileName = files[i].getName().toLowerCase();
            if (StringUtil.isNotEmpty(prefix) && !lowercaseFileName.startsWith(prefix)) continue;
            String ext = StringUtil.cutLastString(lowercaseFileName, '.');
            if (extSet != null && extSet.size() > 0 && !extSet.hasKey(ext)) continue;
            out.add(files[i]);
        }
        return out;
    }

    private static Pair<String, String> parse(String name) {
        int x = name.lastIndexOf("-");
        if (x < 0) {
            x = name.lastIndexOf("_");
        }
        int y = name.lastIndexOf(".");
        if (x < 0 || y < 0 || x > y) {
            return new Pair<String, String>(name, "version");
        }
        String key = name.substring(0, x);
        String version = name.substring(x + 1, y);
        return new Pair<String, String>(key, version);
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes) throws IOException {
        return JarUtil.createJarFile(prefix, classes, null);
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes, Manifest manifest) throws IOException {
        File file = File.createTempFile(prefix, ".jar");
        file.deleteOnExit();
        if (manifest == null) {
            manifest = new Manifest();
        }
        JarOutputStream outStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
        JarUtil.writeFilesToJarStream(classes, file, outStream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFilesToJarStream(Map<String, byte[]> classes, File file, JarOutputStream outStream) throws IOException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            resources.put(entry.getKey().replace('.', '/') + ".class", entry.getValue());
        }
        try {
            JarUtil.addJarEntries(outStream, resources);
        }
        finally {
            outStream.close();
        }
    }

    public static void addJarEntries(JarOutputStream jarStream, Map<String, byte[]> files) throws IOException {
        for (Map.Entry<String, byte[]> entry : files.entrySet()) {
            JarEntry jarEntry = new JarEntry(entry.getKey());
            jarStream.putNextEntry(jarEntry);
            jarStream.write(entry.getValue());
            jarStream.closeEntry();
        }
    }
}

