/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIntLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntIntLinkedEntry[] table;
    private IntIntLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public IntIntLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntIntLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntIntLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new IntIntLinkedEntry(0, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntIntLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(1);
    }

    public synchronized IntEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<IntIntLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        IntIntLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntIntLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized int get(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized int getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized int getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized int getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntIntLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntIntLinkedEntry[] newMap = new IntIntLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntIntLinkedEntry old = oldMap[i];
            while (old != null) {
                IntIntLinkedEntry e = old;
                old = old.hash_next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntIntLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(int key, int value) {
        return this._put(key, value, 4);
    }

    public int putLast(int key, int value) {
        return this._put(key, value, 2);
    }

    public int putFirst(int key, int value) {
        return this._put(key, value, 1);
    }

    public int add(int key, int value) {
        return this._add(key, value, 4);
    }

    public int addLast(int key, int value) {
        return this._add(key, value, 2);
    }

    public int addFirst(int key, int value) {
        return this._add(key, value, 1);
    }

    private synchronized int _put(int key, int value, int m) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(int key, int value) {
    }

    private synchronized int _add(int key, int value, int m) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return e.value;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return value;
    }

    public int addNoOver(int key, int value) {
        return this._addNoOver(key, value, 4);
    }

    private synchronized int _addNoOver(int key, int value, int m) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return e.value;
            }
            e = e.hash_next;
        }
        if (this.max > 0 && this.count >= this.max) {
            return this.NONE;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return value;
    }

    public synchronized int remove(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        IntIntLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        IntIntLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntIntLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntIntLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntIntLinkedEntry link_prev, IntIntLinkedEntry link_next, IntIntLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntIntLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<IntIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            IntIntLinkedEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeDecimal(e.getValue());
        }
    }

    public IntIntLinkedMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            int key = (int)in.readDecimal();
            int value = (int)in.readDecimal();
            this.put(key, value);
        }
        return this;
    }

    public synchronized void sort(Comparator<IntIntLinkedEntry> c) {
        ArrayList<IntIntLinkedEntry> list = new ArrayList<IntIntLinkedEntry>(this.size());
        Enumeration<IntIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            IntIntLinkedEntry e = (IntIntLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        IntIntLinkedMap m = new IntIntLinkedMap().setMax(6);
        for (int i = 0; i < 10; ++i) {
            m.putFirst(i, i);
            System.out.println(m);
        }
        m.setMax(2);
        m.put(100, 100);
        System.out.println(m);
        System.out.println();
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public static class IntIntLinkedEntry {
        int key;
        int value;
        IntIntLinkedEntry hash_next;
        IntIntLinkedEntry link_next;
        IntIntLinkedEntry link_prev;

        protected IntIntLinkedEntry(int key, int value, IntIntLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new IntIntLinkedEntry(this.key, this.value, this.hash_next == null ? null : (IntIntLinkedEntry)this.hash_next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntIntLinkedEntry)) {
                return false;
            }
            IntIntLinkedEntry e = (IntIntLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    IntEnumer {
        byte type;
        IntIntLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((IntIntLinkedMap)IntIntLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && IntIntLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                IntIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                IntIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

