/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;

public class IPUtil {
    public static int IP_127_0_0_1 = IPUtil.toInt("127.0.0.1");
    private static byte[] empty = new byte[]{0, 0, 0, 0};

    public static String toString(int ip) {
        return IPUtil.toString(DataOutputX.toBytes(ip));
    }

    public static int toInt(byte[] ip) {
        return DataInputX.toInt(ip, 0);
    }

    public static String toString(byte[] ip) {
        if (ip == null) {
            return "0.0.0.0";
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(ip[0] & 0xFF);
            sb.append(".");
            sb.append(ip[1] & 0xFF);
            sb.append(".");
            sb.append(ip[2] & 0xFF);
            sb.append(".");
            sb.append(ip[3] & 0xFF);
            return sb.toString();
        }
        catch (Throwable e) {
            return "0.0.0.0";
        }
    }

    private static String[] split(String s) {
        ArrayList<String> arr = new ArrayList<String>(16);
        StringBuilder sb = new StringBuilder(32);
        block3: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(s.charAt(i));
                    continue block3;
                }
                default: {
                    if (sb.length() <= 0) continue block3;
                    arr.add(sb.toString());
                    sb = new StringBuilder(32);
                }
            }
        }
        if (sb.length() > 0) {
            arr.add(sb.toString());
            sb = new StringBuilder(32);
        }
        return arr.toArray(new String[arr.size()]);
    }

    public static byte[] toBytes(String ip) {
        if (ip == null) {
            return empty;
        }
        byte[] result = new byte[4];
        String[] s = IPUtil.split(ip);
        try {
            if (s.length < 4) {
                return empty;
            }
            for (int i = 0; i < 4; ++i) {
                long val = Integer.parseInt(s[i]);
                if (val < 0L || val > 255L) {
                    return empty;
                }
                result[i] = (byte)(val & 0xFFL);
            }
        }
        catch (Throwable e) {
            return empty;
        }
        return result;
    }

    public static byte[] toBytes(int ip) {
        return DataOutputX.toBytes(ip);
    }

    public static boolean isOK(byte[] ip) {
        return ip != null && ip.length == 4;
    }

    public static boolean isNotLocal(byte[] ip) {
        return IPUtil.isOK(ip) && (ip[0] & 0xFF) != 127;
    }

    public static int toInt(String ip) {
        return DataInputX.toInt(IPUtil.toBytes(ip), 0);
    }

    public static boolean isEmpty(byte[] ip) {
        if (ip == null || ip == empty || ip.length != 4) {
            return true;
        }
        return (ip[0] | ip[1] | ip[2] | ip[2]) == 0;
    }
}

