/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.Base64;
import whatap.util.KeyGen;
import whatap.util.StringUtil;

public class CipherAgent {
    private String SEED = "R@WqEeTxr%RtAySuDQW^ERYUAySuDQW^ERTaZXCVRFhGHJKLvsIOfPASgKoDjQ@WqEeTxr%RtBNM%#";
    private String cipherKey;

    private String getSeed() {
        int n = Math.abs((int)KeyGen.next()) % (this.SEED.length() - 3);
        return this.SEED.substring(n, n + 2);
    }

    public CipherAgent(String masterKey) {
        this.cipherKey = StringUtil.isEmpty(masterKey) ? "A#F&#ED@WS%TG" : masterKey;
    }

    private Key genKey(String seed) throws GeneralSecurityException {
        byte[] host = (seed + this.cipherKey + "@EKA%DC$RF").getBytes();
        byte[] key = new byte[8];
        System.arraycopy(host, 0, key, 0, 8);
        return SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key));
    }

    public String decrypt(String encoded) {
        try {
            String seed = encoded.substring(0, 2);
            encoded = encoded.substring(2);
            Key key = this.genKey(seed);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(2, key);
            byte[] cyper = this.decode64(encoded);
            byte[] decoded = cipher.doFinal(cyper);
            return new DataInputX(decoded).readText();
        }
        catch (Exception exception) {
            return encoded;
        }
    }

    public String encrypt(String plain) {
        try {
            String seed = this.getSeed();
            Key key = this.genKey(seed);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] plainBytes = this.padding(new DataOutputX().writeText(plain).toByteArray());
            byte[] encoded = cipher.doFinal(plainBytes);
            return seed + this.encode64(encoded);
        }
        catch (Exception exception) {
            return plain;
        }
    }

    private byte[] decode64(String encoded) throws Exception {
        return Base64.decode(encoded);
    }

    private String encode64(byte[] encoded) {
        return Base64.encode(encoded);
    }

    private byte[] padding(byte[] src) {
        int destlen = (src.length / 8 + 1) * 8;
        byte[] dest = new byte[destlen];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public String decryptIfCipher(String value) {
        if (value == null || !value.startsWith("{{") || !value.endsWith("}}")) {
            return value;
        }
        return this.decrypt(value.substring(2, value.length() - 2));
    }

    public String encryptIfPlain(String value) {
        if (value == null || value.startsWith("{{") && value.endsWith("}}")) {
            return value;
        }
        return "{{" + this.encrypt(value) + "}}";
    }
}

