/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys.linux.tcp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.perfx.sys.PerfXSystem;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.StringEnumer;
import whatap.util.StringIntLinkedMap;

public class TcpStateCounter {
    private static final Properties TCP_STATES = new Properties();

    public static void tcp() {
        File file = new File("/proc/net/tcp");
        if (!file.canRead()) {
            return;
        }
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "serverx_tcp4_count";
        p.tags.put("!rectype", 1);
        TcpStateCounter.calc("tcp4", file, p);
        PerfXSystem.setTagAgentInfo(p);
        DataPackSender.send(p, false);
    }

    public static void tcp6() {
        File file = new File("/proc/net/tcp6");
        if (!file.canRead()) {
            return;
        }
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "serverx_tcp6_count";
        p.tags.put("!rectype", 1);
        TcpStateCounter.calc("tcp6", file, p);
        PerfXSystem.setTagAgentInfo(p);
        DataPackSender.send(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void calc(String protocol, File file, TagCountPack p) {
        StringIntLinkedMap stateCounts = new StringIntLinkedMap();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.trim().split("\\s+");
                if (parts.length <= 3) continue;
                String hexState = parts[3];
                String state = TCP_STATES.getProperty(hexState, "UNKNOWN");
                stateCounts.add(state, 1);
            }
        }
        catch (Exception e) {
            try {
                Logger.println("Error reading " + file + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
        }
        FileUtil.close(reader);
        p.putTag("protocol", protocol);
        StringEnumer en = stateCounts.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            int count = stateCounts.get(key);
            p.fields.put(key, count);
        }
    }

    static {
        TCP_STATES.put("01", "ESTABLISHED");
        TCP_STATES.put("02", "SYN_SENT");
        TCP_STATES.put("03", "SYN_RECV");
        TCP_STATES.put("04", "FIN_WAIT1");
        TCP_STATES.put("05", "FIN_WAIT2");
        TCP_STATES.put("06", "TIME_WAIT");
        TCP_STATES.put("07", "CLOSE");
        TCP_STATES.put("08", "CLOSE_WAIT");
        TCP_STATES.put("09", "LAST_ACK");
        TCP_STATES.put("0A", "LISTEN");
        TCP_STATES.put("0B", "CLOSING");
    }
}

