/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys.linux;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.perfx.sys.PerfXSystem;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxDiskInodeUsage {
    static int readError = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String read() {
        String string;
        if (readError <= 0) {
            return null;
        }
        InputStream is = null;
        OutputStream os = null;
        InputStream es = null;
        try {
            Process process = Runtime.getRuntime().exec("df -i");
            is = process.getInputStream();
            os = process.getOutputStream();
            es = process.getErrorStream();
            byte[] isBytes = FileUtil.readAll(is);
            string = new String(isBytes);
        }
        catch (Throwable th) {
            try {
                --readError;
                Logger.println("df -i", th);
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
                throw throwable;
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            return null;
        }
        FileUtil.close(is);
        FileUtil.close(os);
        FileUtil.close(es);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean process(TagCountPack p) {
        BufferedReader reader = null;
        ListValue idLv = p.fields.newList("@id");
        ListValue[] fLv = null;
        try {
            String line;
            String str = LinuxDiskInodeUsage.read();
            reader = new BufferedReader(new StringReader(str));
            List<String> fields = null;
            while ((line = reader.readLine()) != null) {
                String[] val;
                if (fields == null) {
                    fields = LinuxDiskInodeUsage.readFields(line);
                    fLv = new ListValue[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        fLv[i] = p.fields.newList(fields.get(i));
                    }
                    continue;
                }
                if (line.indexOf("loop") >= 0 || line.startsWith("tmpfs ") || (val = StringUtil.tokenizer(line, " \t")) == null || val.length != fields.size()) continue;
                for (int i = 0; i < val.length; ++i) {
                    String fn = fields.get(i);
                    if (fn.equals("Mounted")) {
                        idLv.add(HashUtil.hash(val[i]));
                        fLv[i].add(val[i]);
                        continue;
                    }
                    if (fn.equals("Filesystem")) {
                        fLv[i].add(val[i]);
                        continue;
                    }
                    if (val[i].startsWith("/")) {
                        fLv[i].add(val[i]);
                        continue;
                    }
                    fLv[i].add(LinuxDiskInodeUsage.toVal(val[i]));
                }
            }
        }
        catch (Exception e) {
            boolean bl;
            try {
                Logger.println(e.toString());
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
            return bl;
        }
        FileUtil.close(reader);
        return true;
    }

    private static List<String> readFields(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        String[] val = StringUtil.tokenizer(line, " \t");
        for (int i = 0; i < val.length; ++i) {
            fields.add(val[i]);
            if (!val[i].equals("Mounted")) continue;
            ++i;
        }
        return fields;
    }

    private static long toVal(String v) {
        if (v.endsWith("%")) {
            return CastUtil.clong(v.substring(0, v.length() - 1));
        }
        return CastUtil.clong(v);
    }

    public static void send() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "linux_disk_inode";
        PerfXSystem.setTagAgentInfo(p);
        p.tags.put("!rectype", 2);
        LinuxDiskInodeUsage.process(p);
        DataPackSender.send(p, false);
    }
}

