/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.workspace;

import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.WsSysConf;
import whatap.agent.net.GetSysIdWithNewTCP;
import whatap.lang.WsKey;

public class LogSinkInfo {
    public static final short PLATFORM_APPLOG = 701;
    public static short SYSID;
    public static String PROPERTY_KEY_PREFIX;
    private static long pcode;

    public static int getOid() {
        return SecurityMaster.getInstance().OID;
    }

    public static long getPcode() {
        return pcode;
    }

    public static boolean isInitialized() {
        if (SYSID > 0) {
            return true;
        }
        if (!SecurityMaster.isWorkspace) {
            return false;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        if (secu.OID == 0) {
            return false;
        }
        short sysid = WsSysConf.read((short)701);
        if (sysid > 0) {
            SYSID = sysid;
            LogSinkInfo.updatePcode(secu);
            return true;
        }
        try {
            sysid = GetSysIdWithNewTCP.requestForSysId(secu.WSID, (short)701, secu.OID);
            if (sysid > 0) {
                WsSysConf.reset((short)701, sysid);
                LogSinkInfo.updatePcode(secu);
                return true;
            }
        }
        catch (Throwable e) {
            Logger.println(e.getMessage());
        }
        return false;
    }

    private static void updatePcode(SecurityMaster secu) {
        pcode = new WsKey(secu.WSID, 701, SYSID).toLongPcode();
        Logger.green("LogSink PCODE=" + WsKey.toString(pcode));
    }

    static {
        PROPERTY_KEY_PREFIX = "property701@";
    }
}

