/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.fw;

import java.util.logging.LogRecord;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.logsink.LineLog;
import whatap.logsink.LineLogUtil;
import whatap.logsink.fw.LogSenderThread;

public class LogTracer {
    static LogSenderThread sender = LogSenderThread.getInstance();

    public static void logcustom(String content) {
        if (ConfLogSink.logsink_custom_enabled && content != null) {
            LineLog lineLog = new LineLog();
            lineLog.category = ConfLogSink.logsink_category_custom;
            LineLogUtil.checkLogContent(lineLog, content);
            if (lineLog.content != null) {
                LogTracer.addTxTag(lineLog);
                sender.add(lineLog);
            }
        }
    }

    public static void logback(Object content) {
        if (ConfLogSink.logsink_logback_enabled && content != null) {
            LineLog lineLog = new LineLog();
            lineLog.category = ConfLogSink.logsink_category_logback;
            LineLogUtil.checkLogContent(lineLog, String.valueOf(content));
            if (lineLog.content != null) {
                LogTracer.addTxTag(lineLog);
                sender.add(lineLog);
            }
        }
    }

    public static StringBuilder log4j(StringBuilder content) {
        if (ConfLogSink.logsink_logback_enabled && content != null) {
            LineLog lineLog = new LineLog();
            lineLog.category = ConfLogSink.logsink_category_log4j;
            LineLogUtil.checkLogContent(lineLog, content.toString());
            if (lineLog.content != null) {
                LogTracer.addTxTag(lineLog);
                sender.add(lineLog);
            }
        }
        return content;
    }

    public static void tomcat(String method, Object content) {
        if (ConfLogSink.logsink_tomcat_enabled) {
            LineLog lineLog = new LineLog();
            lineLog.category = ConfLogSink.logsink_category_tomcat;
            LineLogUtil.checkLogContent(lineLog, String.valueOf(content));
            if (lineLog.content != null && lineLog.content.length() > 1) {
                String level = "INFO";
                if ("warn".equals(method)) {
                    level = "WARNING";
                } else if ("error".equals(method) || "fatal".equals(method)) {
                    level = "SEVERE";
                }
                lineLog.tags.put("level", level);
                LogTracer.addTxTag(lineLog);
                sender.add(lineLog);
            }
        }
    }

    public static void loggerUtil(LogRecord record) {
        if (!ConfLogSink.logsink_logger_util_enabled) {
            return;
        }
        if (record == null) {
            return;
        }
        LineLog lineLog = new LineLog();
        lineLog.category = "LogRecord";
        LineLogUtil.checkLogContent(lineLog, String.valueOf(record.getMessage()));
        StringBuilder sb = new StringBuilder();
        Throwable ex = record.getThrown();
        if (ex != null) {
            lineLog.tags.put("exception", ex.getClass().getName());
            sb.append(ex.getClass().getName()).append(": ").append(ex.getMessage()).append("\n");
            StackTraceElement[] stackTraceElements = ex.getStackTrace();
            int len = Math.min(50, stackTraceElements.length);
            for (int i = 0; i < len; ++i) {
                sb.append("\t").append(stackTraceElements[i]);
                sb.append("\n");
            }
            lineLog.content = lineLog.content + "\n" + sb.toString();
        }
        if (lineLog.content != null && lineLog.content.length() > 1) {
            if (record.getLevel() != null) {
                lineLog.tags.put("level", record.getLevel().getName());
            }
            if (record.getLoggerName() != null) {
                lineLog.tags.put("loggerName", record.getLoggerName());
            }
            if (record.getSourceClassName() != null) {
                lineLog.tags.put("sourceClass", record.getSourceClassName());
            }
            if (record.getSourceMethodName() != null) {
                lineLog.tags.put("sourceMethod", record.getSourceMethodName());
            }
            if (record.getResourceBundleName() != null) {
                lineLog.tags.put("resourceBundle", record.getResourceBundleName());
            }
            if (record.getSequenceNumber() > 0L) {
                lineLog.tags.put("sequenceNumber", record.getSequenceNumber());
            }
            if (record.getThreadID() > 0) {
                lineLog.tags.put("threadId", record.getThreadID());
            }
            LogTracer.addTxTag(lineLog);
            sender.add(lineLog);
        }
    }

    public static void send(LineLog lineLog) {
        sender.add(lineLog);
    }

    public static void addTraceTag(LineLog lineLog) {
        LogTracer.addTxTag(lineLog);
    }

    public static void logdirect(LineLog lineLog) {
        LogTracer.addTxTag(lineLog);
        sender.add(lineLog);
    }

    private static void addTxTag(LineLog lineLog) {
        if (lineLog == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            if (ConfLogSink.logsink_trace_txid_enabled && ctx.txid != 0L) {
                lineLog.fields.put("@txid", ctx.txid);
            }
            if (ConfLogSink.logsink_trace_mtid_enabled && ctx.mtid != 0L) {
                lineLog.fields.put("@mtid", ctx.mtid);
            }
            if (ConfLogSink.logsink_trace_custid_enabled && ctx.custid != null && ctx.custid.length() > 0) {
                lineLog.fields.put("@custid", ctx.custid);
            }
            if (ConfLogSink.logsink_trace_enabled) {
                if (ConfLogSink.logsink_trace_login_enabled && ctx.login != null) {
                    lineLog.fields.put("@login", ctx.login);
                }
                if (ConfLogSink.logsink_trace_httphost_enabled && ctx.http_host != null) {
                    lineLog.tags.put("httphost", ctx.http_host);
                }
            }
        }
    }
}

