/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.org.json.JSONArray;
import whatap.org.json.JSONObject;
import whatap.util.StringEnumer;

public class ValueUtil {
    public static JSONArray toJSON(ListValue list) {
        JSONArray arr = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            Value value = list.get(i);
            arr.put(ValueUtil.valueToJSON(value));
        }
        return arr;
    }

    public static JSONObject toJSON(MapValue map) {
        JSONObject out = new JSONObject();
        StringEnumer en = map.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            Value value = map.get(key);
            out.put(key, ValueUtil.valueToJSON(value));
        }
        return out;
    }

    public static JSONArray toArrayJSON(MapValue map) {
        JSONArray out = new JSONArray();
        StringEnumer en = map.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            Value value = map.get(key);
            if (value instanceof ListValue) {
                ListValue lv = (ListValue)value;
                for (int i = 0; i < lv.size(); ++i) {
                    Value v = lv.get(i);
                    if (i >= out.length()) {
                        out.put(i, new JSONObject().put(key, ValueUtil.valueToJSON(v)));
                        continue;
                    }
                    JSONObject jo = out.getJSONObject(i);
                    jo.put(key, ValueUtil.valueToJSON(v));
                    out.put(i, jo);
                }
                continue;
            }
            out.put(new JSONObject().put(key, ValueUtil.valueToJSON(value)));
        }
        return out;
    }

    private static Object valueToJSON(Value value) {
        if (value instanceof ListValue) {
            return ValueUtil.toJSON((ListValue)value);
        }
        if (value instanceof MapValue) {
            return ValueUtil.toJSON((MapValue)value);
        }
        return JSONObject.wrap(value.toJavaObject());
    }
}

