/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import whatap.lang.value.BlobValue;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.DoubleArray;
import whatap.lang.value.DoubleSummary;
import whatap.lang.value.DoubleValue;
import whatap.lang.value.FloatArray;
import whatap.lang.value.FloatValue;
import whatap.lang.value.IP4Value;
import whatap.lang.value.IntArray;
import whatap.lang.value.IntMapValue;
import whatap.lang.value.IntValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.LongArray;
import whatap.lang.value.LongSummary;
import whatap.lang.value.LongValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.MetricValue;
import whatap.lang.value.NullValue;
import whatap.lang.value.TextArray;
import whatap.lang.value.TextHashValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;

public class ValueEnum {
    public static final byte NULL = 0;
    public static final byte BOOLEAN = 10;
    public static final byte DECIMAL = 20;
    public static final byte DECIMAL_INT = 21;
    public static final byte DECIMAL_LONG = 22;
    public static final byte FLOAT = 30;
    public static final byte DOUBLE = 40;
    public static final byte DOUBLE_SUMMARY = 45;
    public static final byte LONG_SUMMARY = 46;
    public static final byte TEXT = 50;
    public static final byte TEXT_HASH = 51;
    public static final byte BLOB = 60;
    public static final byte IP4ADDR = 61;
    public static final byte LIST = 70;
    public static final byte ARRAY_INT = 71;
    public static final byte ARRAY_FLOAT = 72;
    public static final byte ARRAY_TEXT = 73;
    public static final byte ARRAY_LONG = 74;
    public static final byte ARRAY_DOUBLE = 75;
    public static final byte MAP = 80;
    public static final byte INT_MAP = 81;
    public static final byte METRIC = 82;

    public static Value create(byte code) {
        switch (code) {
            case 0: {
                return new NullValue();
            }
            case 10: {
                return new BooleanValue();
            }
            case 20: {
                return new DecimalValue();
            }
            case 21: {
                return new IntValue();
            }
            case 22: {
                return new LongValue();
            }
            case 30: {
                return new FloatValue();
            }
            case 40: {
                return new DoubleValue();
            }
            case 50: {
                return new TextValue();
            }
            case 51: {
                return new TextHashValue();
            }
            case 60: {
                return new BlobValue();
            }
            case 61: {
                return new IP4Value();
            }
            case 70: {
                return new ListValue();
            }
            case 80: {
                return new MapValue();
            }
            case 81: {
                return new IntMapValue();
            }
            case 46: {
                return new LongSummary();
            }
            case 45: {
                return new DoubleSummary();
            }
            case 71: {
                return new IntArray();
            }
            case 72: {
                return new FloatArray();
            }
            case 73: {
                return new TextArray();
            }
            case 74: {
                return new LongArray();
            }
            case 75: {
                return new DoubleArray();
            }
            case 82: {
                return new MetricValue();
            }
        }
        throw new RuntimeException("unknown value type=" + code);
    }

    public Value toValue(Object o) {
        if (o == null) {
            return new NullValue();
        }
        if (o instanceof Value) {
            return (Value)o;
        }
        if (o instanceof String) {
            return new TextValue((String)o);
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (n instanceof Double) {
                return new DoubleValue((Double)o);
            }
            if (n instanceof Float) {
                return new FloatValue(((Float)o).floatValue());
            }
            return new DecimalValue(n.longValue());
        }
        return new TextValue(o.toString());
    }
}

