/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.SummaryValue;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;

public class LongSummary
extends SummaryValue
implements Value {
    public long sum;
    public int count;
    public long min;
    public long max;

    public byte getValueType() {
        return 46;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeLong(this.sum);
        out.writeInt(this.count);
        out.writeLong(this.min);
        out.writeLong(this.max);
    }

    public Value read(DataInputX in) throws IOException {
        this.sum = in.readLong();
        this.count = in.readInt();
        this.min = in.readLong();
        this.max = in.readLong();
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[sum=").append(this.sum);
        sb.append(",count=").append(this.count);
        sb.append(",min=").append(this.min);
        sb.append(",max=").append(this.max);
        sb.append("]");
        return sb.toString();
    }

    public Object toJavaObject() {
        return this;
    }

    public void addcount() {
        ++this.count;
    }

    public SummaryValue add(Number value) {
        if (value == null) {
            return this;
        }
        if (this.count == 0) {
            this.sum = value.longValue();
            this.count = 1;
            this.max = value.longValue();
            this.min = value.longValue();
        } else {
            this.sum = (long)((double)this.sum + value.doubleValue());
            ++this.count;
            this.max = Math.max(this.max, value.longValue());
            this.min = Math.min(this.min, value.longValue());
        }
        return this;
    }

    public SummaryValue add(SummaryValue other) {
        if (other == null || other.getCount() == 0) {
            return this;
        }
        this.count += other.getCount();
        this.sum += other.longSum();
        this.min = Math.min(this.min, other.longMin());
        this.max = Math.max(this.max, other.longMax());
        return this;
    }

    public long longSum() {
        return this.sum;
    }

    public long longMin() {
        return this.min;
    }

    public long longMax() {
        return this.max;
    }

    public long longAvg() {
        return this.count == 0 ? 0L : this.sum / (long)this.count;
    }

    public double doubleSum() {
        return this.sum;
    }

    public double doubleMin() {
        return this.min;
    }

    public double doubleMax() {
        return this.max;
    }

    public double doubleAvg() {
        return this.count == 0 ? 0.0 : (double)(this.sum / (long)this.count);
    }

    public int getCount() {
        return this.count;
    }

    public int compareTo(Object o) {
        return CompareUtil.compareTo(this.hashCode(), o.hashCode());
    }

    public Value copy() {
        LongSummary o = new LongSummary();
        o.count = this.count;
        o.max = this.max;
        o.min = this.min;
        o.sum = this.sum;
        return o;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

