/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMapValue
implements Value {
    protected IntKeyLinkedMap<Value> table = new IntKeyLinkedMap();

    public IntMapValue() {
    }

    public IntMapValue(IntMapValue m) {
        this.table.putAll(m.table);
    }

    public int size() {
        return this.table.size();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(int key) {
        return this.table.containsKey(key);
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public IntEnumer keys() {
        return this.table.keys();
    }

    public Value get(int key) {
        return this.table.get(key);
    }

    public boolean getBoolean(int key) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(int key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(int key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(int key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(int key) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public Value put(int key, Value value) {
        return this.table.put(key, value);
    }

    public Value put(int key, String value) {
        return this.put(key, new TextValue(value));
    }

    public Value put(int key, long value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value put(int key, int value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value put(int key, float value) {
        return this.put(key, new FloatValue(value));
    }

    public Value put(int key, boolean value) {
        return this.put(key, new BooleanValue(value));
    }

    public Value remove(int key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<Value>> en = this.table.entries();
        buf.append("{");
        while (en.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            IntKeyLinkedMap.IntKeyLinkedEntry<Value> e = en.nextElement();
            buf.append(e.getKey() + "=" + e.getValue());
        }
        buf.append("}");
        return buf.toString();
    }

    public String toJSONString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<Value>> en = this.table.entries();
        buf.append("{");
        while (en.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            StringKeyLinkedMap.StringKeyLinkedEntry e = (StringKeyLinkedMap.StringKeyLinkedEntry)((Object)en.nextElement());
            buf.append('\"').append(e.getKey()).append("\" : ");
            Value value = (Value)e.getValue();
            if (value.getValueType() == 50) {
                buf.append('\"').append(value).append('\"');
                continue;
            }
            if (value.getValueType() == 80) {
                buf.append(((IntMapValue)value).toJSONString());
                continue;
            }
            if (value.getValueType() == 70) {
                buf.append(((ListValue)value).toJSONString());
                continue;
            }
            buf.append(value.toString());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public byte getValueType() {
        return 81;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        int sz = this.table.size();
        dout.writeDecimal(sz);
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<Value>> en = this.table.entries();
        for (int i = 0; i < sz; ++i) {
            IntKeyLinkedMap.IntKeyLinkedEntry<Value> e = en.nextElement();
            dout.writeInt(e.getKey());
            dout.writeValue(e.getValue());
        }
    }

    @Override
    public Value read(DataInputX din) throws IOException {
        int count = (int)din.readDecimal();
        for (int t = 0; t < count; ++t) {
            int key = din.readInt();
            Value value = din.readValue();
            this.put(key, value);
        }
        return this;
    }

    public ListValue newList(int name) {
        ListValue list = new ListValue();
        this.put(name, list);
        return list;
    }

    public ListValue getList(int key) {
        return (ListValue)this.table.get(key);
    }

    public ListValue getListNotNull(int key) {
        ListValue lv = (ListValue)this.table.get(key);
        return lv == null ? new ListValue() : lv;
    }

    public synchronized ListValue internList(int key) {
        ListValue lv = (ListValue)this.table.get(key);
        if (lv == null) {
            lv = new ListValue();
            this.table.put(key, lv);
        }
        return lv;
    }

    @Override
    public Object toJavaObject() {
        return this.table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntMapValue other = (IntMapValue)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<Value>> en = this.table.entries();
        while (en.hasMoreElements()) {
            IntKeyLinkedMap.IntKeyLinkedEntry<Value> ent = en.nextElement();
            Value otherValue = other.get(ent.getKey());
            if (ent.getValue().equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public void putAll(Map<Integer, Value> m) {
        for (Map.Entry<Integer, Value> e : m.entrySet()) {
            this.table.put(e.getKey(), e.getValue());
        }
    }

    public void putAll(IntMapValue m) {
        IntEnumer strEnumer = m.keys();
        while (strEnumer.hasMoreElements()) {
            int key = strEnumer.nextInt();
            this.table.put(key, m.get(key));
        }
    }

    public int getInt(int key, int i) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return i;
    }

    public long getLong(int key, long def) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return def;
    }

    public float getFloat(int key, float def) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return def;
    }

    public String getText(int key, String def) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return def;
    }

    public boolean getBoolean(int key, boolean def) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return def;
    }

    public static boolean isEmpty(IntMapValue r) {
        return r == null || r.size() == 0;
    }

    @Override
    public Value copy() {
        return new IntMapValue(this);
    }

    @Override
    public int compareTo(Object o) {
        return CompareUtil.compareTo(this.hashCode(), o.hashCode());
    }
}

