/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;
import whatap.util.IPUtil;

public class IP4Value
implements Value,
Comparable {
    private static final byte[] empty = new byte[4];
    public byte[] value = empty;

    public IP4Value() {
    }

    public IP4Value(String ip) {
        this.value = IPUtil.toBytes(ip);
    }

    public IP4Value(byte[] value) {
        this.value = value;
    }

    public int compareTo(Object o) {
        if (o instanceof IP4Value) {
            byte[] thisVal = this.value;
            byte[] anotherVal = ((IP4Value)o).value;
            return CompareUtil.compareTo(thisVal, anotherVal);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof IP4Value) {
            byte[] thisVal = this.value;
            byte[] anotherVal = ((IP4Value)o).value;
            if (thisVal == null || anotherVal == null) {
                return thisVal == anotherVal;
            }
            for (int i = 0; i < 4; ++i) {
                if (thisVal[i] == anotherVal[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null || this.value == empty) {
            return 0;
        }
        return DataInputX.toInt(this.value, 0);
    }

    public static void main(String[] args) {
        System.out.println(new IP4Value().hashCode());
    }

    public byte getValueType() {
        return 61;
    }

    public void write(DataOutputX out) throws IOException {
        if (this.value == null) {
            this.value = empty;
        }
        out.write(this.value);
    }

    public Value read(DataInputX in) throws IOException {
        if (this.value == null) {
            this.value = empty;
        }
        this.value = in.read(4);
        return this;
    }

    public String toString() {
        if (this.value == null) {
            this.value = empty;
        }
        return IPUtil.toString(this.value);
    }

    public Object toJavaObject() {
        if (this.value == null) {
            this.value = empty;
        }
        return IPUtil.toString(this.value);
    }

    public Value copy() {
        return new IP4Value(this.value);
    }

    public boolean isEmpty() {
        return this.value == null || CompareUtil.equals(this.value, empty);
    }
}

